/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver.autoconfig;

import com.netflix.spinnaker.kork.configserver.CloudConfigResourceService;
import com.netflix.spinnaker.kork.configserver.ConfigFileService;
import com.netflix.spinnaker.kork.configserver.autoconfig.RemoteConfigSourceConfigured;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.config.server.bootstrap.ConfigServerBootstrapConfiguration;
import org.springframework.cloud.config.server.config.CompositeConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerAutoConfiguration;
import org.springframework.cloud.config.server.config.ConfigServerEncryptionConfiguration;
import org.springframework.cloud.config.server.config.ResourceRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.resource.ResourceRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureAfter(value={ConfigServerAutoConfiguration.class, ConfigServerBootstrapConfiguration.class})
public class CloudConfigAutoConfiguration {
    @Bean
    ConfigFileService configFileService(CloudConfigResourceService cloudConfigResourceService) {
        return new ConfigFileService(cloudConfigResourceService);
    }

    @Configuration
    static class DefaultConfiguration {
        DefaultConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={CloudConfigResourceService.class})
        CloudConfigResourceService cloudConfigResourceService() {
            return new CloudConfigResourceService();
        }
    }

    @Configuration
    @Conditional(value={RemoteConfigSourceConfigured.class})
    @Import(value={CompositeConfiguration.class, ResourceRepositoryConfiguration.class, ConfigServerEncryptionConfiguration.class})
    static class RemoteConfigSourceConfiguration {
        RemoteConfigSourceConfiguration() {
        }

        @Bean
        CloudConfigResourceService cloudConfigResourceService(ResourceRepository resourceRepository, EnvironmentRepository environmentRepository) {
            return new CloudConfigResourceService(resourceRepository, environmentRepository);
        }
    }
}

