/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver;

import com.netflix.spinnaker.kork.configserver.CloudConfigResourceService;
import com.netflix.spinnaker.kork.configserver.ConfigFileLoadingException;
import com.netflix.spinnaker.kork.configserver.ConfigFileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileService {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileService.class);
    private static final String CLASSPATH_FILE_PREFIX = "classpath:";
    private final CloudConfigResourceService cloudConfigResourceService;

    public ConfigFileService(CloudConfigResourceService cloudConfigResourceService) {
        this.cloudConfigResourceService = cloudConfigResourceService;
    }

    public String getLocalPath(String path) {
        if (CloudConfigResourceService.isCloudConfigResource(path) && this.cloudConfigResourceService != null) {
            path = this.cloudConfigResourceService.getLocalPath(path);
        }
        this.verifyLocalPath(path);
        return path;
    }

    public String getLocalPathForContents(String contents, String path) {
        if (StringUtils.isNotEmpty((CharSequence)contents)) {
            return ConfigFileUtils.writeToTempFile(contents, path);
        }
        return null;
    }

    public String getContents(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            if (this.isClasspathResource(path)) {
                return this.retrieveFromClasspath(path);
            }
            return this.retrieveFromLocalPath(this.getLocalPath(path));
        }
        return null;
    }

    private boolean isClasspathResource(String path) {
        return path.startsWith(CLASSPATH_FILE_PREFIX);
    }

    private void verifyLocalPath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path) && !Files.isReadable(Paths.get(path, new String[0]))) {
            throw new ConfigFileLoadingException("File \"" + path + "\" not found or is not readable");
        }
    }

    private String retrieveFromLocalPath(String path) {
        try {
            Path filePath = Paths.get(path, new String[0]);
            return new String(Files.readAllBytes(filePath));
        }
        catch (FileNotFoundException e) {
            throw new ConfigFileLoadingException("File \"" + path + "\" not found or is not readable", e);
        }
        catch (IOException e) {
            throw new ConfigFileLoadingException("Exception reading file " + path, e);
        }
    }

    private String retrieveFromClasspath(String path) {
        try {
            String filePath = path.substring(CLASSPATH_FILE_PREFIX.length());
            InputStream inputStream = this.getClass().getResourceAsStream(filePath);
            return IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ConfigFileLoadingException("Exception reading classpath resource \"" + path + "\"", e);
        }
    }
}

