/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.configserver;

import com.netflix.spinnaker.kork.configserver.CloudConfigAwarePropertySource;
import com.netflix.spinnaker.kork.secrets.SecretAwarePropertySource;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class CloudConfigApplicationListener
implements ApplicationListener<ApplicationPreparedEvent> {
    private static final String APPLICATION_CONFIG_PROPERTY_SOURCE_PREFIX = "applicationConfig:";
    private static final String CONFIG_SERVER_PROPERTY_SOURCE_NAME = "bootstrapProperties";

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        ConfigurableApplicationContext context = event.getApplicationContext();
        ConfigurableEnvironment environment = context.getEnvironment();
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!this.shouldWrap(propertySource)) continue;
            CloudConfigAwarePropertySource wrapper = new CloudConfigAwarePropertySource(propertySource, context);
            environment.getPropertySources().replace(propertySource.getName(), (PropertySource)wrapper);
        }
    }

    private boolean shouldWrap(PropertySource propertySource) {
        return (propertySource.getName().startsWith(APPLICATION_CONFIG_PROPERTY_SOURCE_PREFIX) || propertySource.getName().equals(CONFIG_SERVER_PROPERTY_SOURCE_NAME)) && !(propertySource instanceof CloudConfigAwarePropertySource) && !(propertySource instanceof SecretAwarePropertySource);
    }
}

