/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials;

import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.exceptions.InvalidCredentialsTypeException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class MapBackedCredentialsRepository<T extends Credentials>
implements CredentialsRepository<T> {
    protected Map<String, T> credentials = new ConcurrentHashMap<String, T>();
    @Nullable
    protected CredentialsLifecycleHandler<T> eventHandler;
    protected String type;

    public MapBackedCredentialsRepository(String type, @Nullable CredentialsLifecycleHandler<T> eventHandler) {
        this.type = type;
        this.eventHandler = eventHandler;
    }

    @Override
    public T getOne(String key) {
        return (T)((Credentials)this.credentials.get(key));
    }

    @Override
    public boolean has(String name) {
        return this.credentials.containsKey(name);
    }

    @Override
    public Set<T> getAll() {
        return new HashSet<T>(this.credentials.values());
    }

    @Override
    public void save(T creds) {
        if (!creds.getType().equals(this.getType())) {
            throw new InvalidCredentialsTypeException("Credentials '" + creds.getName() + "' of type '" + creds.getType() + "' cannot be added to repository of type '" + this.getType() + "'");
        }
        if (this.eventHandler != null) {
            if (this.credentials.containsKey(creds.getName())) {
                this.eventHandler.credentialsUpdated(creds);
            } else {
                this.eventHandler.credentialsAdded(creds);
            }
        }
        this.credentials.put(creds.getName(), creds);
    }

    @Override
    public void delete(String key) {
        Credentials credentials = (Credentials)this.credentials.remove(key);
        if (credentials != null && this.eventHandler != null) {
            this.eventHandler.credentialsDeleted(credentials);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }
}

