/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials.definition;

import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BasicCredentialsLoader<T extends CredentialsDefinition, U extends Credentials>
extends AbstractCredentialsLoader<U> {
    protected final CredentialsParser<T, U> parser;
    protected final CredentialsDefinitionSource<T> definitionSource;
    protected boolean parallel;
    protected final Map<String, T> loadedDefinitions = new ConcurrentHashMap<String, T>();

    public BasicCredentialsLoader(CredentialsDefinitionSource<T> definitionSource, CredentialsParser<T, U> parser, CredentialsRepository<U> credentialsRepository) {
        this(definitionSource, parser, credentialsRepository, false);
    }

    public BasicCredentialsLoader(CredentialsDefinitionSource<T> definitionSource, CredentialsParser<T, U> parser, CredentialsRepository<U> credentialsRepository, boolean parallel) {
        super(credentialsRepository);
        this.parser = parser;
        this.definitionSource = definitionSource;
        this.parallel = parallel;
    }

    @Override
    public void load() {
        this.parse(this.definitionSource.getCredentialsDefinitions());
    }

    protected void parse(Collection<T> definitions) {
        Set definitionNames = definitions.stream().map(CredentialsDefinition::getName).collect(Collectors.toSet());
        this.credentialsRepository.getAll().stream().map(Credentials::getName).filter(name -> !definitionNames.contains(name)).peek(this.loadedDefinitions::remove).forEach(this.credentialsRepository::delete);
        ArrayList<U> toApply = new ArrayList<U>();
        for (CredentialsDefinition definition : definitions) {
            U cred;
            if (!this.loadedDefinitions.containsKey(definition.getName())) {
                cred = this.parser.parse(definition);
                if (cred == null) continue;
                toApply.add(cred);
                this.loadedDefinitions.put(definition.getName(), definition);
                continue;
            }
            if (((CredentialsDefinition)this.loadedDefinitions.get(definition.getName())).equals(definition) || (cred = this.parser.parse(definition)) == null) continue;
            toApply.add(cred);
            this.loadedDefinitions.put(definition.getName(), definition);
        }
        Stream stream = this.parallel ? toApply.parallelStream() : toApply.stream();
        stream.forEach(this.credentialsRepository::save);
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isParallel() {
        return this.parallel;
    }
}

