/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials;

import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.exceptions.MissingCredentialsException;
import com.netflix.spinnaker.kork.exceptions.UnknownCredentialsTypeException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CompositeCredentialsRepository<T extends Credentials> {
    private Map<String, CredentialsRepository<? extends T>> allRepositories = new HashMap<String, CredentialsRepository<? extends T>>();

    public CompositeCredentialsRepository(List<CredentialsRepository<? extends T>> repositories) {
        repositories.forEach(this::registerRepository);
    }

    public void registerRepository(CredentialsRepository<? extends T> repository) {
        this.allRepositories.put(repository.getType(), repository);
    }

    public T getCredentials(String credentialsName, String type) {
        CredentialsRepository<T> repository = this.allRepositories.get(type);
        if (repository == null) {
            throw new UnknownCredentialsTypeException("No credentials of type '" + type + "' found");
        }
        T creds = repository.getOne(credentialsName);
        if (creds == null) {
            throw new MissingCredentialsException("Credentials '" + credentialsName + "' of type '" + type + "' cannot be found");
        }
        return creds;
    }

    @Nullable
    public T getFirstCredentialsWithName(String name) {
        return (T)((Credentials)this.allRepositories.values().stream().map(r -> r.getOne(name)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    public List<T> getAllCredentials() {
        return Collections.unmodifiableList(this.allRepositories.values().stream().map(CredentialsRepository::getAll).flatMap(Collection::stream).collect(Collectors.toList()));
    }
}

