/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials;

import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.CredentialsTypeProperties;
import com.netflix.spinnaker.credentials.MapBackedCredentialsRepository;
import com.netflix.spinnaker.credentials.NoopCredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.BasicCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ResolvableType;

public class CredentialsTypeBaseConfiguration<T extends Credentials, U extends CredentialsDefinition>
implements InitializingBean {
    private final ApplicationContext applicationContext;
    private final CredentialsTypeProperties<T, U> properties;
    @Nullable
    private CredentialsRepository<T> credentialsRepository;
    @Nullable
    private AbstractCredentialsLoader<T> credentialsLoader;

    public void afterPropertiesSet() {
        this.registerCredentialsProperties();
    }

    private void registerCredentialsProperties() {
        CredentialsLifecycleHandler lifecycleHandler = this.getParameterizedBean(this.applicationContext, CredentialsLifecycleHandler.class, this.properties.getCredentialsClass()).orElseGet(NoopCredentialsLifecycleHandler::new);
        this.credentialsRepository = this.getParameterizedBean(this.applicationContext, CredentialsRepository.class, this.properties.getCredentialsClass()).orElseGet(() -> this.registerCredentialsRepository(this.applicationContext, this.properties, lifecycleHandler));
        CredentialsDefinitionSource<U> credentialsDefinitionSource = this.getParameterizedBean(this.applicationContext, CredentialsDefinitionSource.class, this.properties.getCredentialsDefinitionClass()).orElse(this.properties.getDefaultCredentialsSource());
        CredentialsParser<U, T> credentialsParser = this.getParameterizedBean(this.applicationContext, CredentialsParser.class, this.properties.getCredentialsDefinitionClass(), this.properties.getCredentialsClass()).orElse(this.properties.getCredentialsParser());
        this.credentialsLoader = this.getParameterizedBean(this.applicationContext, AbstractCredentialsLoader.class, this.properties.getCredentialsClass()).orElseGet(() -> this.registerCredentialsLoader(this.applicationContext, this.properties, credentialsDefinitionSource, credentialsParser, this.credentialsRepository));
    }

    protected CredentialsRepository<T> registerCredentialsRepository(ApplicationContext context, CredentialsTypeProperties<T, ?> properties, CredentialsLifecycleHandler<?> lifecycleHandler) {
        RootBeanDefinition bd = new RootBeanDefinition();
        bd.setTargetType(ResolvableType.forClassWithGenerics(CredentialsRepository.class, (Class[])new Class[]{properties.getCredentialsClass()}));
        bd.setBeanClass(MapBackedCredentialsRepository.class);
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        values.addGenericArgumentValue((Object)properties.getType());
        values.addGenericArgumentValue(lifecycleHandler);
        bd.setConstructorArgumentValues(values);
        String beanName = "credentialsRepository." + properties.getType();
        ((DefaultListableBeanFactory)((AbstractApplicationContext)context).getBeanFactory()).registerBeanDefinition(beanName, (BeanDefinition)bd);
        return (CredentialsRepository)context.getBean(beanName, MapBackedCredentialsRepository.class);
    }

    protected AbstractCredentialsLoader<T> registerCredentialsLoader(ApplicationContext context, CredentialsTypeProperties<T, U> properties, CredentialsDefinitionSource<U> credentialsDefinitionSource, CredentialsParser<U, T> credentialsParser, CredentialsRepository<T> credentialsRepository) {
        RootBeanDefinition bd = new RootBeanDefinition();
        bd.setTargetType(ResolvableType.forClassWithGenerics(AbstractCredentialsLoader.class, (Class[])new Class[]{properties.getCredentialsClass()}));
        bd.setBeanClass(BasicCredentialsLoader.class);
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        values.addGenericArgumentValue(credentialsDefinitionSource);
        values.addGenericArgumentValue(credentialsParser);
        values.addGenericArgumentValue(credentialsRepository);
        values.addGenericArgumentValue((Object)properties.isParallel());
        bd.setConstructorArgumentValues(values);
        String beanName = "credentialsLoader." + properties.getType();
        ((DefaultListableBeanFactory)((AbstractApplicationContext)context).getBeanFactory()).registerBeanDefinition(beanName, (BeanDefinition)bd);
        return (AbstractCredentialsLoader)context.getBean(beanName, AbstractCredentialsLoader.class);
    }

    protected <T> Optional<T> getParameterizedBean(ApplicationContext applicationContext, Class<T> paramClass, Class<?> ... generics) {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(paramClass, (Class[])generics);
        String[] beanNames = applicationContext.getBeanNamesForType(resolvableType);
        if (beanNames.length == 1) {
            return Optional.of(applicationContext.getBean(beanNames[0]));
        }
        if (beanNames.length == 0) {
            return Optional.empty();
        }
        throw new IllegalArgumentException(beanNames.length + " beans found of class " + paramClass + " (" + generics.length + " generics)");
    }

    public CredentialsTypeBaseConfiguration(ApplicationContext applicationContext, CredentialsTypeProperties<T, U> properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Nullable
    public CredentialsRepository<T> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Nullable
    public AbstractCredentialsLoader<T> getCredentialsLoader() {
        return this.credentialsLoader;
    }
}

