/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials.poller;

import com.netflix.spinnaker.credentials.definition.AbstractCredentialsLoader;
import com.netflix.spinnaker.credentials.poller.Poller;
import com.netflix.spinnaker.credentials.poller.PollerConfigurationProperties;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.PeriodicTrigger;

@EnableConfigurationProperties(value={PollerConfigurationProperties.class})
public class PollerConfiguration
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(PollerConfiguration.class);
    private final PollerConfigurationProperties config;
    private final List<AbstractCredentialsLoader<?>> pollers;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        if (this.config.isEnabled()) {
            this.pollers.forEach(poller -> {
                PollerConfigurationProperties.Settings settings = this.config.getSettings(poller.getCredentialsRepository().getType());
                if (settings != null && settings.getReloadFrequencyMs() > 0L) {
                    PeriodicTrigger trigger = new PeriodicTrigger(settings.getReloadFrequencyMs(), TimeUnit.MILLISECONDS);
                    trigger.setInitialDelay(settings.getReloadFrequencyMs());
                    taskRegistrar.addTriggerTask(new Poller(poller), (Trigger)trigger);
                }
            });
        }
    }

    public PollerConfiguration(PollerConfigurationProperties config, List<AbstractCredentialsLoader<?>> pollers) {
        this.config = config;
        this.pollers = pollers;
    }
}

