/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials.poller;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="credentials.poller")
public class PollerConfigurationProperties {
    private static final String DEFAULT_TYPE_KEY = "default";
    private Map<String, Settings> types = new HashMap<String, Settings>();
    private boolean enabled;

    public Settings getSettings(String type) {
        Settings settings = this.types.get(type);
        if (settings != null) {
            return settings;
        }
        return this.types.get(DEFAULT_TYPE_KEY);
    }

    public Map<String, Settings> getTypes() {
        return this.types;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static class Settings {
        private long reloadFrequencyMs = 0L;

        public long getReloadFrequencyMs() {
            return this.reloadFrequencyMs;
        }

        public void setReloadFrequencyMs(long reloadFrequencyMs) {
            this.reloadFrequencyMs = reloadFrequencyMs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getReloadFrequencyMs() == other.getReloadFrequencyMs();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $reloadFrequencyMs = this.getReloadFrequencyMs();
            result = result * 59 + (int)($reloadFrequencyMs >>> 32 ^ $reloadFrequencyMs);
            return result;
        }

        public String toString() {
            return "PollerConfigurationProperties.Settings(reloadFrequencyMs=" + this.getReloadFrequencyMs() + ")";
        }
    }
}

