/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials;

import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;

public class CredentialsTypeProperties<T extends Credentials, U extends CredentialsDefinition> {
    private final String type;
    private final Class<T> credentialsClass;
    private final Class<U> credentialsDefinitionClass;
    private final CredentialsDefinitionSource<U> defaultCredentialsSource;
    private final CredentialsParser<U, T> credentialsParser;
    private final boolean parallel;

    CredentialsTypeProperties(String type, Class<T> credentialsClass, Class<U> credentialsDefinitionClass, CredentialsDefinitionSource<U> defaultCredentialsSource, CredentialsParser<U, T> credentialsParser, boolean parallel) {
        this.type = type;
        this.credentialsClass = credentialsClass;
        this.credentialsDefinitionClass = credentialsDefinitionClass;
        this.defaultCredentialsSource = defaultCredentialsSource;
        this.credentialsParser = credentialsParser;
        this.parallel = parallel;
    }

    public static <T extends Credentials, U extends CredentialsDefinition> CredentialsTypePropertiesBuilder<T, U> builder() {
        return new CredentialsTypePropertiesBuilder();
    }

    public String getType() {
        return this.type;
    }

    public Class<T> getCredentialsClass() {
        return this.credentialsClass;
    }

    public Class<U> getCredentialsDefinitionClass() {
        return this.credentialsDefinitionClass;
    }

    public CredentialsDefinitionSource<U> getDefaultCredentialsSource() {
        return this.defaultCredentialsSource;
    }

    public CredentialsParser<U, T> getCredentialsParser() {
        return this.credentialsParser;
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public static class CredentialsTypePropertiesBuilder<T extends Credentials, U extends CredentialsDefinition> {
        private String type;
        private Class<T> credentialsClass;
        private Class<U> credentialsDefinitionClass;
        private CredentialsDefinitionSource<U> defaultCredentialsSource;
        private CredentialsParser<U, T> credentialsParser;
        private boolean parallel;

        CredentialsTypePropertiesBuilder() {
        }

        public CredentialsTypePropertiesBuilder<T, U> type(String type) {
            this.type = type;
            return this;
        }

        public CredentialsTypePropertiesBuilder<T, U> credentialsClass(Class<T> credentialsClass) {
            this.credentialsClass = credentialsClass;
            return this;
        }

        public CredentialsTypePropertiesBuilder<T, U> credentialsDefinitionClass(Class<U> credentialsDefinitionClass) {
            this.credentialsDefinitionClass = credentialsDefinitionClass;
            return this;
        }

        public CredentialsTypePropertiesBuilder<T, U> defaultCredentialsSource(CredentialsDefinitionSource<U> defaultCredentialsSource) {
            this.defaultCredentialsSource = defaultCredentialsSource;
            return this;
        }

        public CredentialsTypePropertiesBuilder<T, U> credentialsParser(CredentialsParser<U, T> credentialsParser) {
            this.credentialsParser = credentialsParser;
            return this;
        }

        public CredentialsTypePropertiesBuilder<T, U> parallel(boolean parallel) {
            this.parallel = parallel;
            return this;
        }

        public CredentialsTypeProperties<T, U> build() {
            return new CredentialsTypeProperties<T, U>(this.type, this.credentialsClass, this.credentialsDefinitionClass, this.defaultCredentialsSource, this.credentialsParser, this.parallel);
        }

        public String toString() {
            return "CredentialsTypeProperties.CredentialsTypePropertiesBuilder(type=" + this.type + ", credentialsClass=" + this.credentialsClass + ", credentialsDefinitionClass=" + this.credentialsDefinitionClass + ", defaultCredentialsSource=" + this.defaultCredentialsSource + ", credentialsParser=" + this.credentialsParser + ", parallel=" + this.parallel + ")";
        }
    }
}

