/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.StringSerializer;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.credentials.jackson.Sensitive;
import com.netflix.spinnaker.credentials.jackson.SensitiveProperties;
import java.io.IOException;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.jackson.JsonComponent;

@JsonComponent
public class SensitiveSerializer
extends StdScalarSerializer<String>
implements ContextualSerializer {
    private static final Logger log = LogManager.getLogger(SensitiveSerializer.class);
    private final StringSerializer defaultStringSerializer = new StringSerializer();
    private final SensitiveProperties properties;

    public SensitiveSerializer(SensitiveProperties properties) {
        super(String.class);
        this.properties = properties;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        if (property == null) {
            return this.defaultStringSerializer;
        }
        Sensitive sensitive = (Sensitive)property.getAnnotation(Sensitive.class);
        if (sensitive != null) {
            return this;
        }
        Class declaringClass = property.getMember().getDeclaringClass();
        if (CredentialsDefinition.class.isAssignableFrom(declaringClass)) {
            String name = property.getName();
            Matcher matcher = this.properties.getSensitivePropertyNamePattern().matcher(name);
            if (matcher.matches()) {
                log.warn("Encountered likely sensitive property name '{}.{}'. Ignoring this property for serialization.", (Object)declaringClass.getName(), (Object)name);
                return this;
            }
        }
        return this.defaultStringSerializer;
    }

    public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value.startsWith("secret://") || value.startsWith("encrypted:") || value.startsWith("encryptedFile:")) {
            gen.writeString(value);
        } else {
            gen.writeNull();
        }
    }
}

