/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.credentials.poller;

import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.definition.CredentialsLoader;
import com.netflix.spinnaker.credentials.poller.Poller;
import com.netflix.spinnaker.credentials.poller.PollerConfigurationProperties;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.PeriodicTrigger;

@EnableConfigurationProperties(value={PollerConfigurationProperties.class})
@NonnullByDefault
public class PollerConfiguration
implements SchedulingConfigurer {
    private final PollerConfigurationProperties config;
    private final ObjectProvider<CredentialsLoader<? extends Credentials>> pollers;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        if (this.config.isEnabled()) {
            this.pollers.forEach(poller -> {
                PollerConfigurationProperties.Settings settings = this.config.getSettings(poller.getCredentialsRepository().getType());
                if (settings != null && settings.getReloadFrequencyMs() > 0L) {
                    PeriodicTrigger trigger = new PeriodicTrigger(settings.getReloadFrequencyMs(), TimeUnit.MILLISECONDS);
                    trigger.setInitialDelay(settings.getReloadFrequencyMs());
                    taskRegistrar.addTriggerTask(new Poller(poller), (Trigger)trigger);
                }
            });
        }
    }

    public PollerConfiguration(PollerConfigurationProperties config, ObjectProvider<CredentialsLoader<? extends Credentials>> pollers) {
        this.config = config;
        this.pollers = pollers;
    }
}

