/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.NestedSecurityIOException;
import com.netflix.spinnaker.kork.crypto.PasswordProvider;
import com.netflix.spinnaker.kork.crypto.StaticX509Identity;
import com.netflix.spinnaker.kork.crypto.X509Identity;
import com.netflix.spinnaker.kork.crypto.X509IdentitySource;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Enumeration;

public class PasswordProtectedKeyStoreIdentitySource
implements X509IdentitySource {
    private final Path keystoreFile;
    private final String keystoreType;
    private final PasswordProvider keystorePasswordProvider;
    private final PasswordProvider privateKeyPasswordProvider;
    private Instant lastLoaded = Instant.MIN;
    private Instant expiresAt = Instant.MAX;

    @Override
    public Instant getLastModified() {
        try {
            return Files.getLastModifiedTime(this.keystoreFile, new LinkOption[0]).toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public X509Identity load() throws IOException {
        X509Identity identity;
        char[] password;
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(this.keystoreType);
            password = this.keystorePasswordProvider.password();
        }
        catch (GeneralSecurityException e) {
            throw new NestedSecurityIOException(e);
        }
        try (InputStream stream = Files.newInputStream(this.keystoreFile, new OpenOption[0]);){
            keyStore.load(stream, password);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new NestedSecurityIOException(e);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
        try {
            password = this.privateKeyPasswordProvider.password();
            identity = this.findIdentity(keyStore, new KeyStore.PasswordProtection(password));
        }
        catch (GeneralSecurityException e) {
            throw new NestedSecurityIOException(e);
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
        for (X509Certificate certificate : identity.getCertificateChain()) {
            Instant notAfter = certificate.getNotAfter().toInstant();
            if (!this.expiresAt.isAfter(notAfter)) continue;
            this.expiresAt = notAfter;
        }
        this.lastLoaded = Instant.now();
        return identity;
    }

    private X509Identity findIdentity(KeyStore keyStore, KeyStore.ProtectionParameter protectionParameter) throws GeneralSecurityException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            KeyStore.PrivateKeyEntry privateKeyEntry;
            Certificate[] chain;
            KeyStore.Entry entry;
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias) || !((entry = keyStore.getEntry(alias, protectionParameter)) instanceof KeyStore.PrivateKeyEntry) || !((chain = (privateKeyEntry = (KeyStore.PrivateKeyEntry)entry).getCertificateChain()) instanceof X509Certificate[])) continue;
            X509Certificate[] certificateChain = (X509Certificate[])chain;
            PrivateKey privateKey = privateKeyEntry.getPrivateKey();
            return new StaticX509Identity(privateKey, certificateChain);
        }
        throw new IllegalArgumentException("No private key entry found in keystore: " + this.keystoreFile);
    }

    public PasswordProtectedKeyStoreIdentitySource(Path keystoreFile, String keystoreType, PasswordProvider keystorePasswordProvider, PasswordProvider privateKeyPasswordProvider) {
        this.keystoreFile = keystoreFile;
        this.keystoreType = keystoreType;
        this.keystorePasswordProvider = keystorePasswordProvider;
        this.privateKeyPasswordProvider = privateKeyPasswordProvider;
    }

    @Override
    public Instant getLastLoaded() {
        return this.lastLoaded;
    }

    @Override
    public Instant getExpiresAt() {
        return this.expiresAt;
    }
}

