/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.NestedSecurityRuntimeException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class StandardCrypto {
    private StandardCrypto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static CertificateFactory getX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new NestedSecurityRuntimeException(e);
        }
    }

    public static KeyStore getPKCS12KeyStore() {
        try {
            return KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            throw new NestedSecurityRuntimeException(e);
        }
    }

    public static TrustManagerFactory getPKIXTrustManagerFactory() {
        try {
            return TrustManagerFactory.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NestedSecurityRuntimeException(e);
        }
    }

    public static SSLContext getTLSContext() {
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new NestedSecurityRuntimeException(e);
        }
    }
}

