/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import java.util.ArrayList;
import java.util.List;

public final class CipherSuites {
    private static final List<String> REQUIRED = List.of("TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256");
    private static final List<String> BROWSER_COMPATIBILITY = List.of("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
    private static final List<String> RESTRICTED = List.of("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256");

    public static List<String> getRequiredCiphers() {
        return REQUIRED;
    }

    public static List<String> getRecommendedCiphers() {
        ArrayList<String> ciphers = new ArrayList<String>(CipherSuites.getRequiredCiphers());
        ciphers.addAll(BROWSER_COMPATIBILITY);
        return ciphers;
    }

    public static List<String> getIntermediateCompatibilityCiphers() {
        List<String> ciphers = CipherSuites.getRecommendedCiphers();
        ciphers.addAll(RESTRICTED);
        return ciphers;
    }
}

