/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.NestedSecurityRuntimeException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public final class KeyFactories {
    private static final Map<ASN1ObjectIdentifier, KeyFactory> KEY_FACTORIES_BY_ALGORITHM_IDENTIFIER;

    private KeyFactories() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static KeyFactory getKeyFactory(ASN1ObjectIdentifier algorithmIdentifier) {
        KeyFactory keyFactory = KEY_FACTORIES_BY_ALGORITHM_IDENTIFIER.get(algorithmIdentifier);
        if (keyFactory == null) {
            throw new UnsupportedOperationException("Unsupported key algorithm identifier: " + algorithmIdentifier);
        }
        return keyFactory;
    }

    static {
        try {
            KEY_FACTORIES_BY_ALGORITHM_IDENTIFIER = Map.of(X9ObjectIdentifiers.id_ecPublicKey, KeyFactory.getInstance("EC"), PKCSObjectIdentifiers.rsaEncryption, KeyFactory.getInstance("RSA"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NestedSecurityRuntimeException(e);
        }
    }
}

