/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.NestedSecurityRuntimeException;
import java.nio.charset.StandardCharsets;
import java.security.DrbgParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import javax.annotation.Nullable;

public class SecureRandomBuilder {
    private String algorithm = "DRBG";
    @Nullable
    private String providerName;
    @Nullable
    private Provider provider;
    private int bitStrength = -1;
    private boolean reseed;
    private boolean predictionResistance;
    @Nullable
    private byte[] personalizationString;

    public SecureRandomBuilder withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public SecureRandomBuilder withProvider(String provider) {
        this.providerName = provider;
        return this;
    }

    public SecureRandomBuilder withProvider(Provider provider) {
        this.provider = provider;
        return this;
    }

    public SecureRandomBuilder withStrength(int bitStrength) {
        this.bitStrength = bitStrength;
        return this;
    }

    public SecureRandomBuilder withReseedSupport() {
        this.reseed = true;
        return this;
    }

    public SecureRandomBuilder withPredictionResistance() {
        this.predictionResistance = true;
        return this;
    }

    public SecureRandomBuilder withPersonalizationString(byte[] personalizationString) {
        this.personalizationString = (byte[])personalizationString.clone();
        return this;
    }

    public SecureRandomBuilder withPersonalizationString(String personalizationString) {
        this.personalizationString = personalizationString.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public SecureRandom build() {
        DrbgParameters.Capability capability = this.predictionResistance ? DrbgParameters.Capability.PR_AND_RESEED : (this.reseed ? DrbgParameters.Capability.RESEED_ONLY : DrbgParameters.Capability.NONE);
        DrbgParameters.Instantiation parameters = DrbgParameters.instantiation(this.bitStrength, capability, this.personalizationString);
        String name = this.providerName;
        Provider prov = this.provider;
        try {
            if (name != null) {
                return SecureRandom.getInstance(this.algorithm, (SecureRandomParameters)parameters, name);
            }
            if (prov != null) {
                return SecureRandom.getInstance(this.algorithm, (SecureRandomParameters)parameters, prov);
            }
            return SecureRandom.getInstance(this.algorithm, parameters);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new NestedSecurityRuntimeException(e);
        }
    }

    public static SecureRandomBuilder create() {
        return new SecureRandomBuilder();
    }
}

