/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.IdentityX509KeyManager;
import com.netflix.spinnaker.kork.crypto.StandardCrypto;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Destroyable;
import javax.security.auth.x500.X500PrivateCredential;
import org.bouncycastle.crypto.digests.SHAKEDigest;

public interface X509Identity
extends Destroyable {
    public X500PrivateCredential getPrivateCredential();

    public X509Certificate[] getCertificateChain();

    default public SSLContext createSSLContext() throws KeyManagementException {
        SSLContext context = StandardCrypto.getTLSContext();
        KeyManager[] keyManagers = new KeyManager[]{new IdentityX509KeyManager(this)};
        context.init(keyManagers, null, null);
        return context;
    }

    default public SSLContext createSSLContext(X509TrustManager trustManager) throws KeyManagementException {
        SSLContext context = StandardCrypto.getTLSContext();
        context.init(new KeyManager[]{new IdentityX509KeyManager(this)}, new TrustManager[]{trustManager}, null);
        return context;
    }

    default public SSLContext createSSLContext(X509TrustManager trustManager, SecureRandom secureRandom) throws KeyManagementException {
        SSLContext context = StandardCrypto.getTLSContext();
        context.init(new KeyManager[]{new IdentityX509KeyManager(this)}, new TrustManager[]{trustManager}, secureRandom);
        return context;
    }

    public static String generateAlias(Certificate certificate) {
        byte[] encodedPublicKey = certificate.getPublicKey().getEncoded();
        SHAKEDigest digest = new SHAKEDigest();
        digest.update(encodedPublicKey, 0, encodedPublicKey.length);
        byte[] hash = new byte[15];
        digest.doFinal(hash, 0, hash.length);
        return Base64.getEncoder().encodeToString(hash);
    }
}

