/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.X509Identity;
import com.netflix.spinnaker.kork.crypto.X509IdentitySource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import org.springframework.aop.target.dynamic.AbstractRefreshableTargetSource;

public class RefreshableX509Identity
extends AbstractRefreshableTargetSource {
    private final X509IdentitySource identitySource;

    protected X509Identity freshTarget() {
        try {
            return this.identitySource.load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected boolean requiresRefresh() {
        Instant lastLoaded = this.identitySource.getLastLoaded();
        Instant lastModified = this.identitySource.getLastModified();
        Instant expiresAt = this.identitySource.getExpiresAt();
        return lastLoaded.isBefore(lastModified) || Instant.now().isAfter(expiresAt);
    }

    public RefreshableX509Identity(X509IdentitySource identitySource) {
        this.identitySource = identitySource;
    }
}

