/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.PEMIdentitySource;
import com.netflix.spinnaker.kork.crypto.PasswordProtectedKeyStoreIdentitySource;
import com.netflix.spinnaker.kork.crypto.PasswordProvider;
import com.netflix.spinnaker.kork.crypto.RefreshableX509Identity;
import com.netflix.spinnaker.kork.crypto.X509Identity;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;

public interface X509IdentitySource {
    public Instant getLastLoaded();

    public Instant getLastModified();

    public Instant getExpiresAt();

    public X509Identity load() throws IOException;

    default public X509Identity refreshable(Duration refreshCheckDelay) {
        RefreshableX509Identity identity = new RefreshableX509Identity(this);
        identity.setRefreshCheckDelay(refreshCheckDelay.toMillis());
        return (X509Identity)ProxyFactory.getProxy(X509Identity.class, (TargetSource)identity);
    }

    public static X509IdentitySource fromPEM(Path keyFile, Path certificateFile) {
        return new PEMIdentitySource(keyFile, certificateFile);
    }

    public static X509IdentitySource fromPKCS12(Path keystoreFile, PasswordProvider passwordProvider) {
        return X509IdentitySource.fromPKCS12(keystoreFile, passwordProvider, passwordProvider);
    }

    public static X509IdentitySource fromPKCS12(Path keystoreFile, PasswordProvider keystorePasswordProvider, PasswordProvider privateKeyPasswordProvider) {
        return X509IdentitySource.fromKeyStore(keystoreFile, "PKCS12", keystorePasswordProvider, privateKeyPasswordProvider);
    }

    public static X509IdentitySource fromKeyStore(Path keystoreFile, String keystoreType, PasswordProvider passwordProvider) {
        return X509IdentitySource.fromKeyStore(keystoreFile, keystoreType, passwordProvider, passwordProvider);
    }

    public static X509IdentitySource fromKeyStore(Path keystoreFile, String keystoreType, PasswordProvider keystorePasswordProvider, PasswordProvider privateKeyPasswordProvider) {
        return new PasswordProtectedKeyStoreIdentitySource(keystoreFile, keystoreType, keystorePasswordProvider, privateKeyPasswordProvider);
    }
}

