/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.X509Identity;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.x500.X500PrivateCredential;

public class StaticX509Identity
implements X509Identity {
    private final X509Certificate[] certificateChain;
    private final X500PrivateCredential privateCredential;

    public StaticX509Identity(PrivateKey privateKey, X509Certificate[] certificateChain) {
        if (certificateChain.length == 0) {
            throw new IllegalArgumentException("Certificate chain must have at least one certificate");
        }
        this.certificateChain = (X509Certificate[])certificateChain.clone();
        this.privateCredential = new X500PrivateCredential(certificateChain[0], privateKey);
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return (X509Certificate[])this.certificateChain.clone();
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.privateCredential.destroy();
        Arrays.fill(this.certificateChain, null);
    }

    @Override
    public boolean isDestroyed() {
        return this.privateCredential.isDestroyed();
    }

    @Override
    public X500PrivateCredential getPrivateCredential() {
        return this.privateCredential;
    }
}

