/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.KeyFactories;
import com.netflix.spinnaker.kork.crypto.NestedSecurityIOException;
import com.netflix.spinnaker.kork.crypto.StandardCrypto;
import com.netflix.spinnaker.kork.crypto.StaticX509Identity;
import com.netflix.spinnaker.kork.crypto.X509Identity;
import com.netflix.spinnaker.kork.crypto.X509IdentitySource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.ArrayList;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class PEMIdentitySource
implements X509IdentitySource {
    private final Path keyFile;
    private final Path certificateFile;
    private Instant lastLoaded = Instant.MIN;
    private Instant expiresAt = Instant.MAX;

    @Override
    public Instant getLastModified() {
        try {
            return Files.getLastModifiedTime(this.certificateFile, new LinkOption[0]).toInstant();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public X509Identity load() throws IOException {
        PrivateKey privateKey;
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(this.keyFile));){
            PrivateKeyInfo keyInfo;
            Object object = parser.readObject();
            if (object instanceof PrivateKeyInfo) {
                keyInfo = (PrivateKeyInfo)object;
            } else if (object instanceof PEMKeyPair) {
                keyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
            } else {
                throw new UnsupportedEncodingException("Unsupported private key data type: " + object.getClass());
            }
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactories.getKeyFactory(keyInfo.getPrivateKeyAlgorithm().getAlgorithm());
            privateKey = keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new NestedSecurityIOException(e);
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(this.certificateFile));){
            Object parsedCertificate;
            CertificateFactory certificateFactory = StandardCrypto.getX509CertificateFactory();
            while ((parsedCertificate = parser.readObject()) != null) {
                X509CertificateHolder certificateHolder = (X509CertificateHolder)parsedCertificate;
                X509Certificate cert = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(certificateHolder.getEncoded()));
                Instant notAfter = cert.getNotAfter().toInstant();
                if (this.expiresAt.isAfter(notAfter)) {
                    this.expiresAt = notAfter;
                }
                certificates.add(cert);
            }
        }
        catch (CertificateException e) {
            throw new NestedSecurityIOException(e);
        }
        this.lastLoaded = Instant.now();
        return new StaticX509Identity(privateKey, (X509Certificate[])certificates.toArray(X509Certificate[]::new));
    }

    public PEMIdentitySource(Path keyFile, Path certificateFile) {
        this.keyFile = keyFile;
        this.certificateFile = certificateFile;
    }

    @Override
    public Instant getLastLoaded() {
        return this.lastLoaded;
    }

    @Override
    public Instant getExpiresAt() {
        return this.expiresAt;
    }
}

