/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.crypto;

import com.netflix.spinnaker.kork.crypto.NestedSecurityRuntimeException;
import com.netflix.spinnaker.kork.crypto.StandardCrypto;
import com.netflix.spinnaker.kork.crypto.X509Identity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.stream.Stream;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.util.Encodable;

public final class TrustStores {
    private TrustStores() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static KeyStore loadPEM(Path caCertificates) throws CertificateException, IOException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore keyStore = StandardCrypto.getPKCS12KeyStore();
        keyStore.load(null, null);
        try (PEMParser parser = new PEMParser((Reader)Files.newBufferedReader(caCertificates));){
            Object parsedCertificate;
            CertificateFactory certificateFactory = StandardCrypto.getX509CertificateFactory();
            while ((parsedCertificate = parser.readObject()) != null) {
                ByteArrayInputStream certificateStream = new ByteArrayInputStream(((Encodable)parsedCertificate).getEncoded());
                Certificate certificate = certificateFactory.generateCertificate(certificateStream);
                String alias = X509Identity.generateAlias(certificate);
                keyStore.setCertificateEntry(alias, certificate);
            }
        }
        return keyStore;
    }

    public static X509TrustManager loadTrustManager(KeyStore keyStore) throws KeyStoreException {
        TrustManagerFactory trustManagerFactory = StandardCrypto.getPKIXTrustManagerFactory();
        trustManagerFactory.init(keyStore);
        return Stream.of(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Provided KeyStore does not contain any X.509 certificates"));
    }

    public static X509TrustManager getSystemTrustManager() {
        TrustManagerFactory trustManagerFactory = StandardCrypto.getPKIXTrustManagerFactory();
        try {
            trustManagerFactory.init((KeyStore)null);
        }
        catch (KeyStoreException e) {
            throw new NestedSecurityRuntimeException(e);
        }
        return Stream.of(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("No system default trust store configured"));
    }
}

