/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.eureka;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.spinnaker.kork.discovery.RemoteStatusChangedEvent;
import com.netflix.spinnaker.kork.eureka.InstanceStatusUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;

public class EurekaStatusListener
implements ApplicationListener<RemoteStatusChangedEvent> {
    private static final Logger log = LoggerFactory.getLogger(EurekaStatusListener.class);
    private AtomicBoolean enabled = new AtomicBoolean();

    public void onApplicationEvent(RemoteStatusChangedEvent event) {
        log.info("Instance status has changed to {} in Eureka", (Object)event.getSource().getStatus());
        if (InstanceStatusUtil.toEureka(event.getSource().getStatus()) == InstanceInfo.InstanceStatus.UP) {
            this.enabled.set(true);
        } else if (InstanceStatusUtil.toEureka(event.getSource().getPreviousStatus()) == InstanceInfo.InstanceStatus.UP) {
            this.enabled.set(false);
        }
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }
}

