/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class BootHealthCheckHandler
implements HealthCheckHandler,
ApplicationListener<ContextRefreshedEvent> {
    private final HealthIndicator aggregateHealth;
    private final ApplicationInfoManager applicationInfoManager;

    public BootHealthCheckHandler(ApplicationInfoManager applicationInfoManager, HealthAggregator aggregator, Map<String, HealthIndicator> healthIndicators) {
        this.applicationInfoManager = Objects.requireNonNull(applicationInfoManager, "applicationInfoManager");
        this.aggregateHealth = new CompositeHealthIndicator(aggregator, healthIndicators);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.applicationInfoManager.setInstanceStatus(this.getStatus(InstanceInfo.InstanceStatus.UNKNOWN));
    }

    public InstanceInfo.InstanceStatus getStatus(InstanceInfo.InstanceStatus currentStatus) {
        String statusCode = this.aggregateHealth.health().getStatus().getCode();
        if (Status.UP.getCode().equals(statusCode)) {
            return InstanceInfo.InstanceStatus.UP;
        }
        if (Status.OUT_OF_SERVICE.getCode().equals(statusCode)) {
            return InstanceInfo.InstanceStatus.OUT_OF_SERVICE;
        }
        if (Status.DOWN.getCode().equals(statusCode)) {
            return InstanceInfo.InstanceStatus.DOWN;
        }
        return InstanceInfo.InstanceStatus.UNKNOWN;
    }
}

