/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.CloudInstanceConfig;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.eventbus.impl.EventBusImpl;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.spinnaker.kork.discovery.DiscoveryAutoConfiguration;
import com.netflix.spinnaker.kork.eureka.BootHealthCheckHandler;
import com.netflix.spinnaker.kork.eureka.EurekaConfigurationProperties;
import com.netflix.spinnaker.kork.eureka.EurekaStatusSubscriber;
import java.util.Map;
import java.util.Objects;
import javax.inject.Provider;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnProperty(value={"eureka.enabled"})
@EnableConfigurationProperties(value={EurekaConfigurationProperties.class})
@AutoConfigureBefore(value={DiscoveryAutoConfiguration.class})
public class EurekaAutoConfiguration {
    @Bean
    public EventBus eventBus() {
        return new EventBusImpl();
    }

    @Bean
    @Deprecated
    public DiscoveryClient discoveryClient(ApplicationInfoManager applicationInfoManager, EurekaClientConfig eurekaClientConfig, DiscoveryClient.DiscoveryClientOptionalArgs optionalArgs) {
        return new DiscoveryClient(applicationInfoManager, eurekaClientConfig, optionalArgs);
    }

    @Bean
    @Primary
    public EurekaClient eurekaClient(DiscoveryClient discoveryClient) {
        return discoveryClient;
    }

    @Bean
    public ApplicationInfoManager applicationInfoManager(EurekaInstanceConfig eurekaInstanceConfig) {
        return new ApplicationInfoManager(eurekaInstanceConfig, (ApplicationInfoManager.OptionalArgs)null);
    }

    @Bean
    public InstanceInfo instanceInfo(ApplicationInfoManager applicationInfoManager) {
        return applicationInfoManager.getInfo();
    }

    @Bean
    EurekaInstanceConfig eurekaInstanceConfig(EurekaConfigurationProperties eurekaConfigurationProperties) {
        return new CloudInstanceConfig(eurekaConfigurationProperties.getInstance().getNamespace());
    }

    @Bean
    EurekaClientConfig eurekaClientConfig(EurekaConfigurationProperties eurekaConfigurationProperties) {
        return new DefaultEurekaClientConfig(eurekaConfigurationProperties.getClient().getNamespace());
    }

    @Bean
    DiscoveryClient.DiscoveryClientOptionalArgs optionalArgs(EventBus eventBus, HealthCheckHandler healthCheckHandler) {
        DiscoveryClient.DiscoveryClientOptionalArgs args = new DiscoveryClient.DiscoveryClientOptionalArgs();
        args.setEventBus(eventBus);
        args.setHealthCheckHandlerProvider(new StaticProvider<HealthCheckHandler>(healthCheckHandler));
        return args;
    }

    @Bean
    EurekaStatusSubscriber eurekaStatusSubscriber(EventBus eventBus, DiscoveryClient discoveryClient, ApplicationEventPublisher publisher) {
        return new EurekaStatusSubscriber(publisher, eventBus, discoveryClient);
    }

    @Bean
    HealthCheckHandler healthCheckHandler(ApplicationInfoManager applicationInfoManager, HealthAggregator healthAggregator, Map<String, HealthIndicator> healthIndicators) {
        return new BootHealthCheckHandler(applicationInfoManager, healthAggregator, healthIndicators);
    }

    private static class StaticProvider<T>
    implements Provider<T> {
        private final T instance;

        public StaticProvider(T instance) {
            this.instance = Objects.requireNonNull(instance, "instance");
        }

        public T get() {
            return this.instance;
        }
    }
}

