/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.core;

import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import java.time.Duration;
import java.util.function.Supplier;

public class RetrySupport {
    @Deprecated
    public <T> T retry(Supplier<T> fn, int maxRetries, long retryBackoffMillis, boolean exponential) {
        return this.retry(fn, maxRetries, Duration.ofMillis(retryBackoffMillis), exponential);
    }

    public <T> T retry(Supplier<T> fn, int maxRetries, Duration retryBackoff, boolean exponential) {
        int retries = 0;
        while (true) {
            try {
                return fn.get();
            }
            catch (Exception e) {
                Boolean retryable;
                if (e instanceof SpinnakerException && (retryable = ((SpinnakerException)e).getRetryable()) != null && !retryable.booleanValue()) {
                    throw e;
                }
                if (retries >= maxRetries - 1) {
                    throw e;
                }
                long timeout = !exponential ? retryBackoff.toMillis() : (long)Math.pow(2.0, retries) * retryBackoff.toMillis();
                this.sleep(timeout);
                ++retries;
                continue;
            }
            break;
        }
    }

    void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

