/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions;

import com.netflix.spinnaker.kork.expressions.ExpressionEvaluationSummary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.CompositeStringExpression;

public class ExpressionTransform {
    private final Logger logger = LoggerFactory.getLogger(ExpressionTransform.class);
    private final ParserContext parserContext;
    private final ExpressionParser parser;
    private final Function<String, String> stringExpressionPreprocessor;
    private final Collection<Class<?>> typesToStringify;

    public ExpressionTransform(ParserContext parserContext, ExpressionParser parser, Function<String, String> stringExpressionPreprocessor, Class<?> ... typesToStringify) {
        this.parserContext = parserContext;
        this.parser = parser;
        this.stringExpressionPreprocessor = stringExpressionPreprocessor;
        this.typesToStringify = Arrays.asList(typesToStringify);
    }

    private static Stream<?> flatten(Object o) {
        if (o instanceof Map) {
            Map map = (Map)o;
            ArrayList<Object> tokens = new ArrayList<Object>();
            tokens.addAll(map.keySet());
            tokens.addAll(map.values());
            return tokens.stream().flatMap(ExpressionTransform::flatten);
        }
        return Stream.of(o);
    }

    private static Throwable unwrapOriginalException(Throwable e) {
        if (e == null || e.getCause() == null) {
            return e;
        }
        return ExpressionTransform.unwrapOriginalException(e.getCause());
    }

    public static String escapeSimpleExpression(String expression) {
        String escaped = null;
        Matcher matcher = Pattern.compile("\\$\\{(.*)}").matcher(expression);
        if (matcher.matches()) {
            escaped = matcher.group(1).trim();
        }
        return escaped != null ? escaped : expression.replaceAll("\\$", "");
    }

    public Map<String, Object> transformMap(Map<String, Object> source, EvaluationContext evaluationContext, ExpressionEvaluationSummary summary) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> copy = Collections.unmodifiableMap(source);
        source.forEach((key, value) -> {
            if (value instanceof Map) {
                result.put(this.transform(key, evaluationContext, summary, copy).toString(), this.transformMap((Map)value, evaluationContext, summary));
            } else if (value instanceof List) {
                result.put(this.transform(key, evaluationContext, summary, copy).toString(), this.transformList((List)value, evaluationContext, summary, copy));
            } else {
                result.put(this.transform(key, evaluationContext, summary, copy).toString(), this.transform(value, evaluationContext, summary, copy));
            }
        });
        return result;
    }

    public List transformList(List source, EvaluationContext evaluationContext, ExpressionEvaluationSummary summary, Map<String, Object> additionalContext) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : source) {
            if (obj instanceof Map) {
                result.add(this.transformMap((Map)obj, evaluationContext, summary));
                continue;
            }
            if (obj instanceof List) {
                result.add(this.transformList((List)obj, evaluationContext, summary, additionalContext));
                continue;
            }
            result.add(this.transform(obj, evaluationContext, summary, additionalContext));
        }
        return result;
    }

    public String transformString(String source, EvaluationContext evaluationContext, ExpressionEvaluationSummary summary) {
        return (String)this.transform(source, evaluationContext, summary, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object transform(Object source, EvaluationContext evaluationContext, ExpressionEvaluationSummary summary, Map<String, Object> additionalContext) {
        block21: {
            Object fields;
            boolean hasUnresolvedExpressions = false;
            if (!this.isExpression(source)) break block21;
            String preprocessed = this.stringExpressionPreprocessor.apply(source.toString());
            Object result = null;
            String escapedExpressionString = null;
            Exception exception = null;
            try {
                Expression exp = this.parser.parseExpression(preprocessed, this.parserContext);
                escapedExpressionString = this.escapeExpression(exp);
                if (exp instanceof CompositeStringExpression) {
                    Expression[] expressions;
                    StringBuilder sb = new StringBuilder();
                    for (Expression e : expressions = ((CompositeStringExpression)exp).getExpressions()) {
                        String value = (String)e.getValue(evaluationContext, String.class);
                        if (value == null) {
                            value = String.format("${%s}", e.getExpressionString());
                            hasUnresolvedExpressions = true;
                        }
                        sb.append(value);
                    }
                    result = sb.toString();
                } else {
                    result = exp.getValue(evaluationContext);
                }
                Set<String> keys = this.getKeys(source, additionalContext);
                fields = !keys.isEmpty() ? keys : preprocessed;
            }
            catch (Exception e) {
                Object fields2;
                try {
                    this.logger.info("Failed to evaluate {}, returning raw value {}", source, (Object)e.getMessage());
                    exception = e;
                    Set<String> keys = this.getKeys(source, additionalContext);
                    fields2 = !keys.isEmpty() ? keys : preprocessed;
                }
                catch (Throwable throwable) {
                    Set<String> keys = this.getKeys(source, additionalContext);
                    Object fields3 = !keys.isEmpty() ? keys : preprocessed;
                    Object errorDescription = String.format("Failed to evaluate %s ", fields3);
                    String string = escapedExpressionString = escapedExpressionString != null ? escapedExpressionString : ExpressionTransform.escapeSimpleExpression(source.toString());
                    if (exception != null) {
                        Throwable originalException = ExpressionTransform.unwrapOriginalException(exception);
                        errorDescription = originalException == null || originalException.getMessage() == null || originalException.getMessage().contains(exception.getMessage()) ? (String)errorDescription + exception.getMessage() : (String)errorDescription + originalException.getMessage() + " - " + exception.getMessage();
                        summary.add(escapedExpressionString, ExpressionEvaluationSummary.Result.Level.ERROR, ((String)errorDescription).replaceAll("\\$", ""), Optional.ofNullable(originalException).map(Object::getClass).orElse(null));
                        result = source;
                    } else if (result == null || hasUnresolvedExpressions) {
                        summary.add(escapedExpressionString, ExpressionEvaluationSummary.Result.Level.INFO, String.format("%s: %s not found", errorDescription, escapedExpressionString), null);
                        if (result == null) {
                            result = source;
                        }
                    }
                    summary.appendAttempted(escapedExpressionString);
                    summary.incrementTotalEvaluated();
                    throw throwable;
                }
                Object errorDescription = String.format("Failed to evaluate %s ", fields2);
                String string = escapedExpressionString = escapedExpressionString != null ? escapedExpressionString : ExpressionTransform.escapeSimpleExpression(source.toString());
                if (exception != null) {
                    Throwable originalException = ExpressionTransform.unwrapOriginalException(exception);
                    errorDescription = originalException == null || originalException.getMessage() == null || originalException.getMessage().contains(exception.getMessage()) ? (String)errorDescription + exception.getMessage() : (String)errorDescription + originalException.getMessage() + " - " + exception.getMessage();
                    summary.add(escapedExpressionString, ExpressionEvaluationSummary.Result.Level.ERROR, ((String)errorDescription).replaceAll("\\$", ""), Optional.ofNullable(originalException).map(Object::getClass).orElse(null));
                    result = source;
                } else if (result == null || hasUnresolvedExpressions) {
                    summary.add(escapedExpressionString, ExpressionEvaluationSummary.Result.Level.INFO, String.format("%s: %s not found", errorDescription, escapedExpressionString), null);
                    if (result == null) {
                        result = source;
                    }
                }
                summary.appendAttempted(escapedExpressionString);
                summary.incrementTotalEvaluated();
            }
            Object errorDescription = String.format("Failed to evaluate %s ", fields);
            String string = escapedExpressionString = escapedExpressionString != null ? escapedExpressionString : ExpressionTransform.escapeSimpleExpression(source.toString());
            if (exception != null) {
                Throwable originalException = ExpressionTransform.unwrapOriginalException(exception);
                errorDescription = originalException == null || originalException.getMessage() == null || originalException.getMessage().contains(exception.getMessage()) ? (String)errorDescription + exception.getMessage() : (String)errorDescription + originalException.getMessage() + " - " + exception.getMessage();
                summary.add(escapedExpressionString, ExpressionEvaluationSummary.Result.Level.ERROR, ((String)errorDescription).replaceAll("\\$", ""), Optional.ofNullable(originalException).map(Object::getClass).orElse(null));
                result = source;
            } else if (result == null || hasUnresolvedExpressions) {
                summary.add(escapedExpressionString, ExpressionEvaluationSummary.Result.Level.INFO, String.format("%s: %s not found", errorDescription, escapedExpressionString), null);
                if (result == null) {
                    result = source;
                }
            }
            summary.appendAttempted(escapedExpressionString);
            summary.incrementTotalEvaluated();
            if (this.typesToStringify.contains(result.getClass())) {
                result = result.toString();
            }
            return result;
        }
        return source;
    }

    private boolean isExpression(Object obj) {
        return obj instanceof String && obj.toString().contains(this.parserContext.getExpressionPrefix());
    }

    private Set<String> getKeys(Object value, Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        return map.entrySet().stream().filter(it -> ExpressionTransform.flatten(it.getValue()).collect(Collectors.toSet()).stream().flatMap(Stream::of).collect(Collectors.toSet()).contains(value)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private String escapeExpression(Expression expression) {
        if (expression instanceof CompositeStringExpression) {
            StringBuilder sb = new StringBuilder();
            for (Expression e : ((CompositeStringExpression)expression).getExpressions()) {
                sb.append(e.getExpressionString());
            }
            return sb.toString();
        }
        return expression.getExpressionString();
    }
}

