/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions.allowlist;

import com.netflix.spinnaker.kork.expressions.allowlist.ReturnTypeRestrictor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;

public class FilteredPropertyAccessor
extends ReflectivePropertyAccessor {
    private final ReturnTypeRestrictor returnTypeRestrictor;

    public FilteredPropertyAccessor(ReturnTypeRestrictor returnTypeRestrictor) {
        this.returnTypeRestrictor = returnTypeRestrictor;
    }

    protected Method findGetterForProperty(String propertyName, Class<?> clazz, boolean mustBeStatic) {
        Method getter = super.findGetterForProperty(propertyName, clazz, mustBeStatic);
        if (getter == null) {
            throw new IllegalArgumentException(String.format("requested getter %s not found on type %s", propertyName, clazz));
        }
        if (!this.returnTypeRestrictor.supports(getter.getReturnType())) {
            throw new IllegalArgumentException(String.format("found getter for requested %s but rejected due to return type %s", propertyName, getter.getReturnType()));
        }
        return getter;
    }

    protected Field findField(String name, Class<?> clazz, boolean mustBeStatic) {
        Field field = super.findField(name, clazz, mustBeStatic);
        if (field == null) {
            throw new IllegalArgumentException(String.format("requested field %s not found on type %s", name, clazz));
        }
        if (!this.returnTypeRestrictor.supports(field.getType())) {
            throw new IllegalArgumentException(String.format("found field %s but rejected due to unsupported type %s", name, clazz));
        }
        return field;
    }
}

