/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions.allowlist;

import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;

public class MapPropertyAccessor
extends MapAccessor {
    private final boolean allowUnknownKeys;

    public MapPropertyAccessor(boolean allowUnknownKeys) {
        this.allowUnknownKeys = allowUnknownKeys;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        if (this.allowUnknownKeys) {
            return true;
        }
        return super.canRead(context, target, name);
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        try {
            return super.read(context, target, name);
        }
        catch (AccessException ae) {
            if (this.allowUnknownKeys) {
                return TypedValue.NULL;
            }
            throw ae;
        }
    }
}

