/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions;

import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactDecorator;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardTypeConverter;

public class ArtifactUriToReferenceConverter
implements TypeConverter {
    private final ArtifactStore artifactStore;
    private final StandardTypeConverter defaultTypeConverter = new StandardTypeConverter();

    public ArtifactUriToReferenceConverter(ArtifactStore artifactStore) {
        this.artifactStore = artifactStore;
    }

    public boolean canConvert(TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        if (sourceType == null) {
            return false;
        }
        return sourceType.getObjectType() == String.class && targetType.getObjectType() == String.class;
    }

    public Object convertValue(Object value, TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        if (!this.canConvert(sourceType, targetType)) {
            return this.defaultTypeConverter.convertValue(value, sourceType, targetType);
        }
        if (this.artifactStore == null || !this.artifactStore.isArtifactURI((String)value)) {
            return this.defaultTypeConverter.convertValue(value, sourceType, targetType);
        }
        return this.artifactStore.get((String)value, new ArtifactDecorator[0]).getReference();
    }
}

