/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions;

import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactDecorator;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactReferenceURI;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardTypeConverter;

public class ArtifactUriToReferenceConverter
implements TypeConverter {
    private final ArtifactStore artifactStore;
    private final StandardTypeConverter defaultTypeConverter = new StandardTypeConverter();

    public ArtifactUriToReferenceConverter(ArtifactStore artifactStore) {
        this.artifactStore = artifactStore;
    }

    public boolean canConvert(TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        return this.isArtifactUriType(sourceType, targetType) || this.defaultTypeConverter.canConvert(sourceType, targetType);
    }

    private boolean isArtifactUriType(TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        return sourceType != null && sourceType.getObjectType() == String.class && targetType.getObjectType() == String.class;
    }

    public Object convertValue(Object value, TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        if (!this.isArtifactUriType(sourceType, targetType)) {
            return this.defaultTypeConverter.convertValue(value, sourceType, targetType);
        }
        if (this.artifactStore == null || !this.artifactStore.isArtifactURI((String)value)) {
            return this.defaultTypeConverter.convertValue(value, sourceType, targetType);
        }
        return this.artifactStore.get(ArtifactReferenceURI.parse((String)((String)value)), new ArtifactDecorator[0]).getReference();
    }
}

