/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.api.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.kork.artifacts.artifactstore.ArtifactStore;
import com.netflix.spinnaker.kork.expressions.ArtifactUriToReferenceConverter;
import com.netflix.spinnaker.kork.expressions.NotEvaluableExpression;
import com.netflix.spinnaker.kork.expressions.SpelHelperFunctionException;
import com.netflix.spinnaker.kork.expressions.allowlist.AllowListTypeLocator;
import com.netflix.spinnaker.kork.expressions.allowlist.FilteredMethodResolver;
import com.netflix.spinnaker.kork.expressions.allowlist.FilteredPropertyAccessor;
import com.netflix.spinnaker.kork.expressions.allowlist.MapPropertyAccessor;
import com.netflix.spinnaker.kork.expressions.allowlist.ReturnTypeRestrictor;
import com.netflix.spinnaker.kork.expressions.config.ExpressionProperties;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionsSupport.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Set<Class<?>> allowedReturnTypes;
    private final List<ExpressionFunctionProvider> expressionFunctionProviders;
    private final ExpressionProperties expressionProperties;

    public ExpressionsSupport(Class<?> extraAllowedReturnType, ExpressionProperties expressionProperties) {
        this(new Class[]{extraAllowedReturnType}, null, null, expressionProperties);
    }

    public ExpressionsSupport(Class<?>[] extraAllowedReturnTypes, List<ExpressionFunctionProvider> extraExpressionFunctionProviders, PluginManager pluginManager, ExpressionProperties expressionProperties) {
        this.expressionProperties = expressionProperties;
        this.allowedReturnTypes = new HashSet<Class>(Arrays.asList(Collection.class, Map.class, SortedMap.class, List.class, Set.class, SortedSet.class, ArrayList.class, LinkedList.class, HashSet.class, LinkedHashSet.class, HashMap.class, LinkedHashMap.class, TreeMap.class, TreeSet.class));
        Collections.addAll(this.allowedReturnTypes, extraAllowedReturnTypes);
        this.expressionFunctionProviders = new ArrayList<ExpressionFunctionProvider>(Arrays.asList(new JsonExpressionFunctionProvider(), new StringExpressionFunctionProvider()));
        if (extraExpressionFunctionProviders != null) {
            this.expressionFunctionProviders.addAll(extraExpressionFunctionProviders);
        }
        if (pluginManager != null) {
            this.expressionFunctionProviders.addAll(pluginManager.getExtensions(ExpressionFunctionProvider.class));
        }
        if (expressionProperties.getDoNotEvalSpel().isEnabled()) {
            this.allowedReturnTypes.add(NotEvaluableExpression.class);
            this.expressionFunctionProviders.add(new FlowExpressionFunctionProvider());
        }
    }

    public List<ExpressionFunctionProvider> getExpressionFunctionProviders() {
        return this.expressionFunctionProviders;
    }

    private static void registerFunction(StandardEvaluationContext context, String registrationName, Class<?> cls, String methodName, Class<?> ... types) {
        try {
            context.registerFunction(registrationName, cls.getDeclaredMethod(methodName, types));
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("Failed to register helper function", (Throwable)e);
            throw new RuntimeException("Failed to register helper function '" + registrationName + "' from '" + cls.getName() + "#" + methodName + "'", e);
        }
    }

    public StandardEvaluationContext buildEvaluationContext(Object rootObject, boolean allowUnknownKeys) {
        StandardEvaluationContext evaluationContext = this.createEvaluationContext(rootObject, allowUnknownKeys);
        this.registerExpressionProviderFunctions(evaluationContext);
        return evaluationContext;
    }

    private StandardEvaluationContext createEvaluationContext(Object rootObject, boolean allowUnknownKeys) {
        ReturnTypeRestrictor returnTypeRestrictor = new ReturnTypeRestrictor(this.allowedReturnTypes);
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext(rootObject);
        evaluationContext.setTypeLocator((TypeLocator)new AllowListTypeLocator());
        evaluationContext.setTypeConverter((TypeConverter)new ArtifactUriToReferenceConverter(ArtifactStore.getInstance()));
        evaluationContext.setMethodResolvers(Collections.singletonList(new FilteredMethodResolver(returnTypeRestrictor)));
        evaluationContext.setPropertyAccessors(Arrays.asList(new PropertyAccessor[]{new MapPropertyAccessor(allowUnknownKeys), new FilteredPropertyAccessor(returnTypeRestrictor)}));
        return evaluationContext;
    }

    private void registerExpressionProviderFunctions(StandardEvaluationContext evaluationContext) {
        for (ExpressionFunctionProvider p : this.expressionFunctionProviders) {
            for (ExpressionFunctionProvider.FunctionDefinition function : p.getFunctions().getFunctionsDefinitions()) {
                String namespacedFunctionName = function.getName();
                if (p.getNamespace() != null) {
                    namespacedFunctionName = String.format("%s_%s", p.getNamespace(), namespacedFunctionName);
                }
                Class[] functionTypes = (Class[])function.getParameters().stream().map(ExpressionFunctionProvider.FunctionParameter::getType).toArray(Class[]::new);
                ExpressionsSupport.registerFunction(evaluationContext, namespacedFunctionName, p.getExtensionClass(), function.getName(), functionTypes);
            }
        }
    }

    public static class StringExpressionFunctionProvider
    implements ExpressionFunctionProvider {
        public static Integer toInt(String str) {
            return Integer.valueOf(str);
        }

        public static Float toFloat(String str) {
            return Float.valueOf(str);
        }

        public static Boolean toBoolean(String str) {
            return Boolean.valueOf(str);
        }

        public static String toBase64(String text) {
            return Base64.getEncoder().encodeToString(text.getBytes());
        }

        public static String fromBase64(String text) {
            return new String(Base64.getDecoder().decode(text), StandardCharsets.UTF_8);
        }

        public static String alphanumerical(String str) {
            return str.replaceAll("[^A-Za-z0-9]", "");
        }

        public String getNamespace() {
            return null;
        }

        public ExpressionFunctionProvider.Functions getFunctions() {
            return new ExpressionFunctionProvider.Functions(new ExpressionFunctionProvider.FunctionDefinition[]{new ExpressionFunctionProvider.FunctionDefinition("toInt", "Converts a string to integer", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "value", "A String value to convert to an int")}), new ExpressionFunctionProvider.FunctionDefinition("toFloat", "Converts a string to float", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "value", "A String value to convert to a float")}), new ExpressionFunctionProvider.FunctionDefinition("toBoolean", "Converts a string value to boolean", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "value", "A String value to convert to a boolean")}), new ExpressionFunctionProvider.FunctionDefinition("toBase64", "Encodes a string to base64 string", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "value", "A String value to base64 encode")}), new ExpressionFunctionProvider.FunctionDefinition("fromBase64", "Decodes a base64 string", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "value", "A base64-encoded String value to decode")}), new ExpressionFunctionProvider.FunctionDefinition("alphanumerical", "Removes all non-alphanumeric characters from a string", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "value", "A String value to strip of all non-alphanumeric characters")})});
        }
    }

    public static class JsonExpressionFunctionProvider
    implements ExpressionFunctionProvider {
        public static String toJson(Object o) {
            try {
                if (o instanceof NotEvaluableExpression) {
                    return mapper.writeValueAsString(((NotEvaluableExpression)o).getExpression());
                }
                String converted = mapper.writeValueAsString(o);
                if (converted != null && converted.contains("${")) {
                    throw new SpelHelperFunctionException("result for toJson cannot contain an expression");
                }
                return converted;
            }
            catch (Exception e) {
                throw new SpelHelperFunctionException(String.format("#toJson(%s) failed", o.toString()), e);
            }
        }

        public String getNamespace() {
            return null;
        }

        public ExpressionFunctionProvider.Functions getFunctions() {
            return new ExpressionFunctionProvider.Functions(new ExpressionFunctionProvider.FunctionDefinition[]{new ExpressionFunctionProvider.FunctionDefinition("toJson", "Converts an object to JSON string", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(Object.class, "value", "An Object to marshall to a JSON String")})});
        }
    }

    public static class FlowExpressionFunctionProvider
    implements ExpressionFunctionProvider {
        public static NotEvaluableExpression doNotEval(Object o) {
            return new NotEvaluableExpression(o);
        }

        public String getNamespace() {
            return null;
        }

        public ExpressionFunctionProvider.Functions getFunctions() {
            return new ExpressionFunctionProvider.Functions(new ExpressionFunctionProvider.FunctionDefinition[]{new ExpressionFunctionProvider.FunctionDefinition("doNotEval", "Restrict expressions evaluation for an object", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(Object.class, "value", "An object to restrict expressions evaluation")})});
        }
    }
}

