/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.expressions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ExpressionEvaluationSummary {
    private Map<String, Set<Result>> expressionResult = new HashMap<String, Set<Result>>();
    private Set<String> attempts;
    private AtomicInteger failureCount = new AtomicInteger();
    private AtomicInteger totalEvaluated = new AtomicInteger();

    public ExpressionEvaluationSummary() {
        this.attempts = new HashSet<String>();
    }

    public int getTotalEvaluated() {
        return this.totalEvaluated.get();
    }

    public int getFailureCount() {
        return this.failureCount.get();
    }

    public Map<String, Set<Result>> getExpressionResult() {
        return this.expressionResult;
    }

    public void add(String escapedExpression, Result.Level level, String description, Class<?> exceptionType) {
        Set messages = this.expressionResult.getOrDefault(escapedExpression, new HashSet());
        messages.add(new Result(level, System.currentTimeMillis(), description, exceptionType));
        this.expressionResult.put(escapedExpression, messages);
        this.failureCount.incrementAndGet();
    }

    public void incrementTotalEvaluated() {
        this.totalEvaluated.incrementAndGet();
    }

    public void appendAttempted(String expression) {
        this.attempts.add(expression);
    }

    public String toString() {
        String attempted = this.attempts.stream().collect(Collectors.joining(","));
        String failed = this.expressionResult.keySet().stream().collect(Collectors.joining(","));
        return String.format("%d expression(s) - (%s), %d failed - (%s)", this.getTotalEvaluated(), attempted, this.getFailureCount(), failed);
    }

    public boolean wasAttempted(String expression) {
        return this.attempts.contains(expression);
    }

    public boolean hasFailed(String expression) {
        return this.expressionResult.containsKey(expression);
    }

    public static class Result {
        private String description;
        private Class<?> exceptionType;
        private long timestamp;
        private Level level;

        public Result(Level level, long timestamp, String description, Class<?> exceptionType) {
            this.level = level;
            this.timestamp = timestamp;
            this.description = description;
            this.exceptionType = exceptionType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public Level getLevel() {
            return this.level;
        }

        public void setLevel(Level level) {
            this.level = level;
        }

        public Class<?> getExceptionType() {
            return this.exceptionType;
        }

        public void setExceptionType(Class<?> exceptionType) {
            this.exceptionType = exceptionType;
        }

        public String toString() {
            return "Result {description='" + this.description + "', exceptionType=" + String.valueOf(this.exceptionType) + ", timestamp=" + this.timestamp + ", level=" + String.valueOf((Object)this.level) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return (this.description != null ? this.description.equals(result.description) : result.description == null) && (this.exceptionType != null ? this.exceptionType.equals(result.exceptionType) : result.exceptionType == null) && this.level == result.level;
        }

        public int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.exceptionType != null ? this.exceptionType.hashCode() : 0);
            result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
            return result;
        }

        static enum Level {
            ERROR,
            INFO;

        }
    }
}

