/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class EmbeddedRedis
implements AutoCloseable {
    private static final int REDIS_PORT = 6379;
    private final GenericContainer<?> redisContainer = new GenericContainer(DockerImageName.parse((String)"library/redis:5-alpine")).withExposedPorts(new Integer[]{6379});
    private JedisPool jedis;

    private EmbeddedRedis() {
        this.redisContainer.start();
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        this.redisContainer.stop();
    }

    public String getHost() {
        return this.redisContainer.getHost();
    }

    public int getPort() {
        return this.redisContainer.getMappedPort(6379);
    }

    public JedisPool getPool() {
        if (this.jedis == null) {
            this.jedis = new JedisPool(this.getHost(), this.getPort());
        }
        return this.jedis;
    }

    public Jedis getJedis() {
        return this.getPool().getResource();
    }

    public static EmbeddedRedis embed() {
        return new EmbeddedRedis();
    }
}

