/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis.telemetry;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileDistributionSummary;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.kork.jedis.telemetry.InstrumentedJedisException;
import com.netflix.spinnaker.kork.jedis.telemetry.TelemetryHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Client;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

public class InstrumentedPipeline
extends Pipeline {
    private final Registry registry;
    private final Pipeline delegated;
    private final String poolName;

    public InstrumentedPipeline(Registry registry, Pipeline delegated) {
        this(registry, delegated, "unnamed");
    }

    public InstrumentedPipeline(Registry registry, Pipeline delegated, String poolName) {
        this.registry = registry;
        this.delegated = delegated;
        this.poolName = poolName;
    }

    private <T> T instrumented(String command, Callable<T> action) {
        return this.internalInstrumented(command, Optional.empty(), action);
    }

    private <T> T instrumented(String command, long payloadSize, Callable<T> action) {
        return this.internalInstrumented(command, Optional.of(payloadSize), action);
    }

    private <T> T internalInstrumented(String command, Optional<Long> payloadSize, Callable<T> action) {
        payloadSize.ifPresent(size -> PercentileDistributionSummary.get((Registry)this.registry, (Id)TelemetryHelper.payloadSizeId(this.registry, this.poolName, command, true)).record(size.longValue()));
        try {
            return (T)PercentileTimer.get((Registry)this.registry, (Id)TelemetryHelper.timerId(this.registry, this.poolName, command, true)).record(() -> {
                Object result = action.call();
                this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, true, true)).increment();
                return result;
            });
        }
        catch (Exception e) {
            this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, true, false)).increment();
            throw new InstrumentedJedisException("could not execute delegate function", e);
        }
    }

    private void instrumented(String command, Runnable action) {
        this.internalInstrumented(command, Optional.empty(), action);
    }

    private void instrumented(String command, long payloadSize, Runnable action) {
        this.internalInstrumented(command, Optional.of(payloadSize), action);
    }

    private void internalInstrumented(String command, Optional<Long> payloadSize, Runnable action) {
        payloadSize.ifPresent(size -> PercentileDistributionSummary.get((Registry)this.registry, (Id)TelemetryHelper.payloadSizeId(this.registry, this.poolName, command, true)).record(size.longValue()));
        try {
            PercentileTimer.get((Registry)this.registry, (Id)TelemetryHelper.timerId(this.registry, this.poolName, command, true)).record(() -> {
                action.run();
                this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, true, true)).increment();
            });
        }
        catch (Exception e) {
            this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, true, false)).increment();
            throw new InstrumentedJedisException("could not execute delegate function", e);
        }
    }

    public void setClient(Client client) {
        this.delegated.setClient(client);
    }

    public void clear() {
        this.delegated.clear();
    }

    public boolean isInMulti() {
        String command = "isInMulti";
        return this.instrumented(command, () -> this.delegated.isInMulti());
    }

    public void sync() {
        this.delegated.sync();
    }

    public List<Object> syncAndReturnAll() {
        String command = "syncAndReturnAll";
        return this.instrumented(command, () -> this.delegated.syncAndReturnAll());
    }

    public Response<String> discard() {
        String command = "discard";
        return this.instrumented(command, () -> this.delegated.discard());
    }

    public Response<List<Object>> exec() {
        String command = "exec";
        return this.instrumented(command, () -> this.delegated.exec());
    }

    public Response<String> multi() {
        String command = "multi";
        return this.instrumented(command, () -> this.delegated.multi());
    }

    public void close() {
        super.close();
        this.delegated.close();
    }

    public Response<List<String>> brpop(String ... args) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(args));
    }

    public Response<List<String>> brpop(int timeout, String ... keys) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(timeout, keys));
    }

    public Response<List<String>> blpop(String ... args) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(args));
    }

    public Response<List<String>> blpop(int timeout, String ... keys) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(timeout, keys));
    }

    public Response<Map<String, String>> blpopMap(int timeout, String ... keys) {
        String command = "blpopMap";
        return this.instrumented(command, () -> this.delegated.blpopMap(timeout, keys));
    }

    public Response<List<byte[]>> brpop(byte[] ... args) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(args));
    }

    public Response<List<String>> brpop(int timeout, byte[] ... keys) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(timeout, keys));
    }

    public Response<Map<String, String>> brpopMap(int timeout, String ... keys) {
        String command = "brpopMap";
        return this.instrumented(command, () -> this.delegated.brpopMap(timeout, keys));
    }

    public Response<List<byte[]>> blpop(byte[] ... args) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(args));
    }

    public Response<List<String>> blpop(int timeout, byte[] ... keys) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(timeout, keys));
    }

    public Response<Long> del(String ... keys) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(keys));
    }

    public Response<Long> del(byte[] ... keys) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(keys));
    }

    public Response<Long> exists(String ... keys) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(keys));
    }

    public Response<Long> exists(byte[] ... keys) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(keys));
    }

    public Response<Set<String>> keys(String pattern) {
        String command = "keys";
        return this.instrumented(command, () -> this.delegated.keys(pattern));
    }

    public Response<Set<byte[]>> keys(byte[] pattern) {
        String command = "keys";
        return this.instrumented(command, () -> this.delegated.keys(pattern));
    }

    public Response<List<String>> mget(String ... keys) {
        String command = "mget";
        return this.instrumented(command, () -> this.delegated.mget(keys));
    }

    public Response<List<byte[]>> mget(byte[] ... keys) {
        String command = "mget";
        return this.instrumented(command, () -> this.delegated.mget(keys));
    }

    public Response<String> mset(String ... keysvalues) {
        String command = "mset";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.mset(keysvalues));
    }

    public Response<String> mset(byte[] ... keysvalues) {
        String command = "mset";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.mset(keysvalues));
    }

    public Response<Long> msetnx(String ... keysvalues) {
        String command = "msetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.msetnx(keysvalues));
    }

    public Response<Long> msetnx(byte[] ... keysvalues) {
        String command = "msetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.msetnx(keysvalues));
    }

    public Response<String> rename(String oldkey, String newkey) {
        String command = "rename";
        return this.instrumented(command, () -> this.delegated.rename(oldkey, newkey));
    }

    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        String command = "rename";
        return this.instrumented(command, () -> this.delegated.rename(oldkey, newkey));
    }

    public Response<Long> renamenx(String oldkey, String newkey) {
        String command = "renamenx";
        return this.instrumented(command, () -> this.delegated.renamenx(oldkey, newkey));
    }

    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        String command = "renamenx";
        return this.instrumented(command, () -> this.delegated.renamenx(oldkey, newkey));
    }

    public Response<String> rpoplpush(String srckey, String dstkey) {
        String command = "rpoplpush";
        return this.instrumented(command, () -> this.delegated.rpoplpush(srckey, dstkey));
    }

    public Response<byte[]> rpoplpush(byte[] srckey, byte[] dstkey) {
        String command = "rpoplpush";
        return this.instrumented(command, () -> this.delegated.rpoplpush(srckey, dstkey));
    }

    public Response<Set<String>> sdiff(String ... keys) {
        String command = "sdiff";
        return this.instrumented(command, () -> this.delegated.sdiff(keys));
    }

    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        String command = "sdiff";
        return this.instrumented(command, () -> this.delegated.sdiff(keys));
    }

    public Response<Long> sdiffstore(String dstkey, String ... keys) {
        String command = "sdiffstore";
        return this.instrumented(command, () -> this.delegated.sdiffstore(dstkey, keys));
    }

    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        String command = "sdiffstore";
        return this.instrumented(command, () -> this.delegated.sdiffstore(dstkey, keys));
    }

    public Response<Set<String>> sinter(String ... keys) {
        String command = "sinter";
        return this.instrumented(command, () -> this.delegated.sinter(keys));
    }

    public Response<Set<byte[]>> sinter(byte[] ... keys) {
        String command = "sinter";
        return this.instrumented(command, () -> this.delegated.sinter(keys));
    }

    public Response<Long> sinterstore(String dstkey, String ... keys) {
        String command = "sinterstore";
        return this.instrumented(command, () -> this.delegated.sinterstore(dstkey, keys));
    }

    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        String command = "sinterstore";
        return this.instrumented(command, () -> this.delegated.sinterstore(dstkey, keys));
    }

    public Response<Long> smove(String srckey, String dstkey, String member) {
        String command = "smove";
        return this.instrumented(command, () -> this.delegated.smove(srckey, dstkey, member));
    }

    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        String command = "smove";
        return this.instrumented(command, () -> this.delegated.smove(srckey, dstkey, member));
    }

    public Response<Long> sort(String key, SortingParams sortingParameters, String dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters, dstkey));
    }

    public Response<Long> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters, dstkey));
    }

    public Response<Long> sort(String key, String dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, dstkey));
    }

    public Response<Long> sort(byte[] key, byte[] dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, dstkey));
    }

    public Response<Set<String>> sunion(String ... keys) {
        String command = "sunion";
        return this.instrumented(command, () -> this.delegated.sunion(keys));
    }

    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        String command = "sunion";
        return this.instrumented(command, () -> this.delegated.sunion(keys));
    }

    public Response<Long> sunionstore(String dstkey, String ... keys) {
        String command = "sunionstore";
        return this.instrumented(command, () -> this.delegated.sunionstore(dstkey, keys));
    }

    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        String command = "sunionstore";
        return this.instrumented(command, () -> this.delegated.sunionstore(dstkey, keys));
    }

    public Response<String> watch(String ... keys) {
        String command = "watch";
        return this.instrumented(command, () -> this.delegated.watch(keys));
    }

    public Response<String> watch(byte[] ... keys) {
        String command = "watch";
        return this.instrumented(command, () -> this.delegated.watch(keys));
    }

    public Response<Long> zinterstore(String dstkey, String ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, sets));
    }

    public Response<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, sets));
    }

    public Response<Long> zinterstore(String dstkey, ZParams params, String ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, params, sets));
    }

    public Response<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, params, sets));
    }

    public Response<Long> zunionstore(String dstkey, String ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, sets));
    }

    public Response<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, sets));
    }

    public Response<Long> zunionstore(String dstkey, ZParams params, String ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, params, sets));
    }

    public Response<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, params, sets));
    }

    public Response<String> bgrewriteaof() {
        String command = "bgrewriteaof";
        return this.instrumented(command, () -> this.delegated.bgrewriteaof());
    }

    public Response<String> bgsave() {
        String command = "bgsave";
        return this.instrumented(command, () -> this.delegated.bgsave());
    }

    public Response<List<String>> configGet(String pattern) {
        String command = "configGet";
        return this.instrumented(command, () -> this.delegated.configGet(pattern));
    }

    public Response<String> configSet(String parameter, String value) {
        String command = "configSet";
        return this.instrumented(command, () -> this.delegated.configSet(parameter, value));
    }

    public Response<String> brpoplpush(String source, String destination, int timeout) {
        String command = "brpoplpush";
        return this.instrumented(command, () -> this.delegated.brpoplpush(source, destination, timeout));
    }

    public Response<byte[]> brpoplpush(byte[] source, byte[] destination, int timeout) {
        String command = "brpoplpush";
        return this.instrumented(command, () -> this.delegated.brpoplpush(source, destination, timeout));
    }

    public Response<String> configResetStat() {
        String command = "configResetStat";
        return this.instrumented(command, () -> this.delegated.configResetStat());
    }

    public Response<String> save() {
        String command = "save";
        return this.instrumented(command, () -> this.delegated.save());
    }

    public Response<Long> lastsave() {
        String command = "lastsave";
        return this.instrumented(command, () -> this.delegated.lastsave());
    }

    public Response<Long> publish(String channel, String message) {
        String command = "publish";
        return this.instrumented(command, TelemetryHelper.payloadSize(message), () -> this.delegated.publish(channel, message));
    }

    public Response<Long> publish(byte[] channel, byte[] message) {
        String command = "publish";
        return this.instrumented(command, TelemetryHelper.payloadSize(message), () -> this.delegated.publish(channel, message));
    }

    public Response<String> randomKey() {
        String command = "randomKey";
        return this.instrumented(command, () -> this.delegated.randomKey());
    }

    public Response<byte[]> randomKeyBinary() {
        String command = "randomKeyBinary";
        return this.instrumented(command, () -> this.delegated.randomKeyBinary());
    }

    public Response<String> flushDB() {
        String command = "flushDB";
        return this.instrumented(command, () -> this.delegated.flushDB());
    }

    public Response<String> flushAll() {
        String command = "flushAll";
        return this.instrumented(command, () -> this.delegated.flushAll());
    }

    public Response<String> info() {
        String command = "info";
        return this.instrumented(command, () -> this.delegated.info());
    }

    public Response<String> info(String section) {
        String command = "info";
        return this.instrumented(command, () -> this.delegated.info(section));
    }

    public Response<List<String>> time() {
        String command = "time";
        return this.instrumented(command, () -> this.delegated.time());
    }

    public Response<Long> dbSize() {
        String command = "dbSize";
        return this.instrumented(command, () -> this.delegated.dbSize());
    }

    public Response<String> shutdown() {
        String command = "shutdown";
        return this.instrumented(command, () -> this.delegated.shutdown());
    }

    public Response<String> ping() {
        String command = "ping";
        return this.instrumented(command, () -> this.delegated.ping());
    }

    public Response<String> select(int index) {
        String command = "select";
        return this.instrumented(command, () -> this.delegated.select(index));
    }

    public Response<Long> bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        String command = "bitop";
        return this.instrumented(command, () -> this.delegated.bitop(op, destKey, srcKeys));
    }

    public Response<Long> bitop(BitOP op, String destKey, String ... srcKeys) {
        String command = "bitop";
        return this.instrumented(command, () -> this.delegated.bitop(op, destKey, srcKeys));
    }

    public Response<String> clusterNodes() {
        String command = "clusterNodes";
        return this.instrumented(command, () -> this.delegated.clusterNodes());
    }

    public Response<String> clusterMeet(String ip, int port) {
        String command = "clusterMeet";
        return this.instrumented(command, () -> this.delegated.clusterMeet(ip, port));
    }

    public Response<String> clusterAddSlots(int ... slots) {
        String command = "clusterAddSlots";
        return this.instrumented(command, () -> this.delegated.clusterAddSlots(slots));
    }

    public Response<String> clusterDelSlots(int ... slots) {
        String command = "clusterDelSlots";
        return this.instrumented(command, () -> this.delegated.clusterDelSlots(slots));
    }

    public Response<String> clusterInfo() {
        String command = "clusterInfo";
        return this.instrumented(command, () -> this.delegated.clusterInfo());
    }

    public Response<List<String>> clusterGetKeysInSlot(int slot, int count) {
        String command = "clusterGetKeysInSlot";
        return this.instrumented(command, () -> this.delegated.clusterGetKeysInSlot(slot, count));
    }

    public Response<String> clusterSetSlotNode(int slot, String nodeId) {
        String command = "clusterSetSlotNode";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotNode(slot, nodeId));
    }

    public Response<String> clusterSetSlotMigrating(int slot, String nodeId) {
        String command = "clusterSetSlotMigrating";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotMigrating(slot, nodeId));
    }

    public Response<String> clusterSetSlotImporting(int slot, String nodeId) {
        String command = "clusterSetSlotImporting";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotImporting(slot, nodeId));
    }

    public Response<Object> eval(byte[] script) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.eval(script));
    }

    public Response<Object> eval(byte[] script, byte[] keyCount, byte[] ... params) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(params), () -> this.delegated.eval(script, keyCount, params));
    }

    public Response<Object> eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(args), () -> this.delegated.eval(script, keys, args));
    }

    public Response<Object> eval(byte[] script, int keyCount, byte[] ... params) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(params), () -> this.delegated.eval(script, keyCount, params));
    }

    public Response<Object> evalsha(byte[] sha1) {
        String command = "evalsha";
        return this.instrumented(command, () -> this.delegated.evalsha(sha1));
    }

    public Response<Object> evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(args), () -> this.delegated.evalsha(sha1, keys, args));
    }

    public Response<Object> evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(params), () -> this.delegated.evalsha(sha1, keyCount, params));
    }

    public Response<String> pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        String command = "pfmerge";
        return this.instrumented(command, () -> this.delegated.pfmerge(destkey, sourcekeys));
    }

    public Response<String> pfmerge(String destkey, String ... sourcekeys) {
        String command = "pfmerge";
        return this.instrumented(command, () -> this.delegated.pfmerge(destkey, sourcekeys));
    }

    public Response<Long> pfcount(String ... keys) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(keys));
    }

    public Response<Long> pfcount(byte[] ... keys) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(keys));
    }

    public Response<Long> append(String key, String value) {
        String command = "append";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.append(key, value));
    }

    public Response<Long> append(byte[] key, byte[] value) {
        String command = "append";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.append(key, value));
    }

    public Response<List<String>> blpop(String key) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(key));
    }

    public Response<List<String>> brpop(String key) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(key));
    }

    public Response<List<byte[]>> blpop(byte[] key) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(key));
    }

    public Response<List<byte[]>> brpop(byte[] key) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(key));
    }

    public Response<Long> decr(String key) {
        String command = "decr";
        return this.instrumented(command, () -> this.delegated.decr(key));
    }

    public Response<Long> decr(byte[] key) {
        String command = "decr";
        return this.instrumented(command, () -> this.delegated.decr(key));
    }

    public Response<Long> decrBy(String key, long integer) {
        String command = "decrBy";
        return this.instrumented(command, () -> this.delegated.decrBy(key, integer));
    }

    public Response<Long> decrBy(byte[] key, long integer) {
        String command = "decrBy";
        return this.instrumented(command, () -> this.delegated.decrBy(key, integer));
    }

    public Response<Long> del(String key) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(key));
    }

    public Response<Long> del(byte[] key) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(key));
    }

    public Response<String> echo(String string) {
        String command = "echo";
        return this.instrumented(command, () -> this.delegated.echo(string));
    }

    public Response<byte[]> echo(byte[] string) {
        String command = "echo";
        return this.instrumented(command, () -> this.delegated.echo(string));
    }

    public Response<Boolean> exists(String key) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(key));
    }

    public Response<Boolean> exists(byte[] key) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(key));
    }

    public Response<Long> expire(String key, int seconds) {
        String command = "expire";
        return this.instrumented(command, () -> this.delegated.expire(key, seconds));
    }

    public Response<Long> expire(byte[] key, int seconds) {
        String command = "expire";
        return this.instrumented(command, () -> this.delegated.expire(key, seconds));
    }

    public Response<Long> expireAt(String key, long unixTime) {
        String command = "expireAt";
        return this.instrumented(command, () -> this.delegated.expireAt(key, unixTime));
    }

    public Response<Long> expireAt(byte[] key, long unixTime) {
        String command = "expireAt";
        return this.instrumented(command, () -> this.delegated.expireAt(key, unixTime));
    }

    public Response<String> get(String key) {
        String command = "get";
        return this.instrumented(command, () -> this.delegated.get(key));
    }

    public Response<byte[]> get(byte[] key) {
        String command = "get";
        return this.instrumented(command, () -> this.delegated.get(key));
    }

    public Response<Boolean> getbit(String key, long offset) {
        String command = "getbit";
        return this.instrumented(command, () -> this.delegated.getbit(key, offset));
    }

    public Response<Boolean> getbit(byte[] key, long offset) {
        String command = "getbit";
        return this.instrumented(command, () -> this.delegated.getbit(key, offset));
    }

    public Response<Long> bitpos(String key, boolean value) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value));
    }

    public Response<Long> bitpos(String key, boolean value, BitPosParams params) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value, params));
    }

    public Response<Long> bitpos(byte[] key, boolean value) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value));
    }

    public Response<Long> bitpos(byte[] key, boolean value, BitPosParams params) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value, params));
    }

    public Response<String> getrange(String key, long startOffset, long endOffset) {
        String command = "getrange";
        return this.instrumented(command, () -> this.delegated.getrange(key, startOffset, endOffset));
    }

    public Response<String> getSet(String key, String value) {
        String command = "getSet";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.getSet(key, value));
    }

    public Response<byte[]> getSet(byte[] key, byte[] value) {
        String command = "getSet";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.getSet(key, value));
    }

    public Response<byte[]> getrange(byte[] key, long startOffset, long endOffset) {
        String command = "getrange";
        return this.instrumented(command, () -> this.delegated.getrange(key, startOffset, endOffset));
    }

    public Response<Long> hdel(String key, String ... field) {
        String command = "hdel";
        return this.instrumented(command, () -> this.delegated.hdel(key, field));
    }

    public Response<Long> hdel(byte[] key, byte[] ... field) {
        String command = "hdel";
        return this.instrumented(command, () -> this.delegated.hdel(key, field));
    }

    public Response<Boolean> hexists(String key, String field) {
        String command = "hexists";
        return this.instrumented(command, () -> this.delegated.hexists(key, field));
    }

    public Response<Boolean> hexists(byte[] key, byte[] field) {
        String command = "hexists";
        return this.instrumented(command, () -> this.delegated.hexists(key, field));
    }

    public Response<String> hget(String key, String field) {
        String command = "hget";
        return this.instrumented(command, () -> this.delegated.hget(key, field));
    }

    public Response<byte[]> hget(byte[] key, byte[] field) {
        String command = "hget";
        return this.instrumented(command, () -> this.delegated.hget(key, field));
    }

    public Response<Map<String, String>> hgetAll(String key) {
        String command = "hgetAll";
        return this.instrumented(command, () -> this.delegated.hgetAll(key));
    }

    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        String command = "hgetAll";
        return this.instrumented(command, () -> this.delegated.hgetAll(key));
    }

    public Response<Long> hincrBy(String key, String field, long value) {
        String command = "hincrBy";
        return this.instrumented(command, () -> this.delegated.hincrBy(key, field, value));
    }

    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        String command = "hincrBy";
        return this.instrumented(command, () -> this.delegated.hincrBy(key, field, value));
    }

    public Response<Set<String>> hkeys(String key) {
        String command = "hkeys";
        return this.instrumented(command, () -> this.delegated.hkeys(key));
    }

    public Response<Set<byte[]>> hkeys(byte[] key) {
        String command = "hkeys";
        return this.instrumented(command, () -> this.delegated.hkeys(key));
    }

    public Response<Long> hlen(String key) {
        String command = "hlen";
        return this.instrumented(command, () -> this.delegated.hlen(key));
    }

    public Response<Long> hlen(byte[] key) {
        String command = "hlen";
        return this.instrumented(command, () -> this.delegated.hlen(key));
    }

    public Response<List<String>> hmget(String key, String ... fields) {
        String command = "hmget";
        return this.instrumented(command, () -> this.delegated.hmget(key, fields));
    }

    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        String command = "hmget";
        return this.instrumented(command, () -> this.delegated.hmget(key, fields));
    }

    public Response<String> hmset(String key, Map<String, String> hash) {
        String command = "hmset";
        return this.instrumented(command, () -> this.delegated.hmset(key, hash));
    }

    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        String command = "hmset";
        return this.instrumented(command, () -> this.delegated.hmset(key, hash));
    }

    public Response<Long> hset(String key, String field, String value) {
        String command = "hset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hset(key, field, value));
    }

    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        String command = "hset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hset(key, field, value));
    }

    public Response<Long> hsetnx(String key, String field, String value) {
        String command = "hsetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hsetnx(key, field, value));
    }

    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        String command = "hsetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hsetnx(key, field, value));
    }

    public Response<List<String>> hvals(String key) {
        String command = "hvals";
        return this.instrumented(command, () -> this.delegated.hvals(key));
    }

    public Response<List<byte[]>> hvals(byte[] key) {
        String command = "hvals";
        return this.instrumented(command, () -> this.delegated.hvals(key));
    }

    public Response<Long> incr(String key) {
        String command = "incr";
        return this.instrumented(command, () -> this.delegated.incr(key));
    }

    public Response<Long> incr(byte[] key) {
        String command = "incr";
        return this.instrumented(command, () -> this.delegated.incr(key));
    }

    public Response<Long> incrBy(String key, long integer) {
        String command = "incrBy";
        return this.instrumented(command, () -> this.delegated.incrBy(key, integer));
    }

    public Response<Long> incrBy(byte[] key, long integer) {
        String command = "incrBy";
        return this.instrumented(command, () -> this.delegated.incrBy(key, integer));
    }

    public Response<String> lindex(String key, long index) {
        String command = "lindex";
        return this.instrumented(command, () -> this.delegated.lindex(key, index));
    }

    public Response<byte[]> lindex(byte[] key, long index) {
        String command = "lindex";
        return this.instrumented(command, () -> this.delegated.lindex(key, index));
    }

    public Response<Long> llen(String key) {
        String command = "llen";
        return this.instrumented(command, () -> this.delegated.llen(key));
    }

    public Response<Long> llen(byte[] key) {
        String command = "llen";
        return this.instrumented(command, () -> this.delegated.llen(key));
    }

    public Response<String> lpop(String key) {
        String command = "lpop";
        return this.instrumented(command, () -> this.delegated.lpop(key));
    }

    public Response<byte[]> lpop(byte[] key) {
        String command = "lpop";
        return this.instrumented(command, () -> this.delegated.lpop(key));
    }

    public Response<Long> lpush(String key, String ... string) {
        String command = "lpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.lpush(key, string));
    }

    public Response<Long> lpush(byte[] key, byte[] ... string) {
        String command = "lpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.lpush(key, string));
    }

    public Response<Long> lpushx(String key, String ... string) {
        String command = "lpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.lpushx(key, string));
    }

    public Response<Long> lpushx(byte[] key, byte[] ... bytes) {
        String command = "lpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(bytes), () -> this.delegated.lpushx(key, bytes));
    }

    public Response<List<String>> lrange(String key, long start, long end) {
        String command = "lrange";
        return this.instrumented(command, () -> this.delegated.lrange(key, start, end));
    }

    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        String command = "lrange";
        return this.instrumented(command, () -> this.delegated.lrange(key, start, end));
    }

    public Response<Long> lrem(String key, long count, String value) {
        String command = "lrem";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lrem(key, count, value));
    }

    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        String command = "lrem";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lrem(key, count, value));
    }

    public Response<String> lset(String key, long index, String value) {
        String command = "lset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lset(key, index, value));
    }

    public Response<String> lset(byte[] key, long index, byte[] value) {
        String command = "lset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lset(key, index, value));
    }

    public Response<String> ltrim(String key, long start, long end) {
        String command = "ltrim";
        return this.instrumented(command, () -> this.delegated.ltrim(key, start, end));
    }

    public Response<String> ltrim(byte[] key, long start, long end) {
        String command = "ltrim";
        return this.instrumented(command, () -> this.delegated.ltrim(key, start, end));
    }

    public Response<Long> move(String key, int dbIndex) {
        String command = "move";
        return this.instrumented(command, () -> this.delegated.move(key, dbIndex));
    }

    public Response<Long> move(byte[] key, int dbIndex) {
        String command = "move";
        return this.instrumented(command, () -> this.delegated.move(key, dbIndex));
    }

    public Response<Long> persist(String key) {
        String command = "persist";
        return this.instrumented(command, () -> this.delegated.persist(key));
    }

    public Response<Long> persist(byte[] key) {
        String command = "persist";
        return this.instrumented(command, () -> this.delegated.persist(key));
    }

    public Response<String> rpop(String key) {
        String command = "rpop";
        return this.instrumented(command, () -> this.delegated.rpop(key));
    }

    public Response<byte[]> rpop(byte[] key) {
        String command = "rpop";
        return this.instrumented(command, () -> this.delegated.rpop(key));
    }

    public Response<Long> rpush(String key, String ... string) {
        String command = "rpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.rpush(key, string));
    }

    public Response<Long> rpush(byte[] key, byte[] ... string) {
        String command = "rpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.rpush(key, string));
    }

    public Response<Long> rpushx(String key, String ... string) {
        String command = "rpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.rpushx(key, string));
    }

    public Response<Long> rpushx(byte[] key, byte[] ... string) {
        String command = "rpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.rpushx(key, string));
    }

    public Response<Long> sadd(String key, String ... member) {
        String command = "sadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.sadd(key, member));
    }

    public Response<Long> sadd(byte[] key, byte[] ... member) {
        String command = "sadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.sadd(key, member));
    }

    public Response<Long> scard(String key) {
        String command = "scard";
        return this.instrumented(command, () -> this.delegated.scard(key));
    }

    public Response<Long> scard(byte[] key) {
        String command = "scard";
        return this.instrumented(command, () -> this.delegated.scard(key));
    }

    public Response<String> set(String key, String value) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value));
    }

    public Response<String> set(byte[] key, byte[] value) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value));
    }

    public Response<Boolean> setbit(String key, long offset, boolean value) {
        String command = "setbit";
        return this.instrumented(command, () -> this.delegated.setbit(key, offset, value));
    }

    public Response<Boolean> setbit(byte[] key, long offset, byte[] value) {
        String command = "setbit";
        return this.instrumented(command, () -> this.delegated.setbit(key, offset, value));
    }

    public Response<String> setex(String key, int seconds, String value) {
        String command = "setex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setex(key, seconds, value));
    }

    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        String command = "setex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setex(key, seconds, value));
    }

    public Response<Long> setnx(String key, String value) {
        String command = "setnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setnx(key, value));
    }

    public Response<Long> setnx(byte[] key, byte[] value) {
        String command = "setnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setnx(key, value));
    }

    public Response<Long> setrange(String key, long offset, String value) {
        String command = "setrange";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setrange(key, offset, value));
    }

    public Response<Long> setrange(byte[] key, long offset, byte[] value) {
        String command = "setrange";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setrange(key, offset, value));
    }

    public Response<Boolean> sismember(String key, String member) {
        String command = "sismember";
        return this.instrumented(command, () -> this.delegated.sismember(key, member));
    }

    public Response<Boolean> sismember(byte[] key, byte[] member) {
        String command = "sismember";
        return this.instrumented(command, () -> this.delegated.sismember(key, member));
    }

    public Response<Set<String>> smembers(String key) {
        String command = "smembers";
        return this.instrumented(command, () -> this.delegated.smembers(key));
    }

    public Response<Set<byte[]>> smembers(byte[] key) {
        String command = "smembers";
        return this.instrumented(command, () -> this.delegated.smembers(key));
    }

    public Response<List<String>> sort(String key) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key));
    }

    public Response<List<byte[]>> sort(byte[] key) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key));
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters));
    }

    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters));
    }

    public Response<String> spop(String key) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key));
    }

    public Response<Set<String>> spop(String key, long count) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key, count));
    }

    public Response<byte[]> spop(byte[] key) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key));
    }

    public Response<Set<byte[]>> spop(byte[] key, long count) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key, count));
    }

    public Response<String> srandmember(String key) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key));
    }

    public Response<List<String>> srandmember(String key, int count) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key, count));
    }

    public Response<byte[]> srandmember(byte[] key) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key));
    }

    public Response<List<byte[]>> srandmember(byte[] key, int count) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key, count));
    }

    public Response<Long> srem(String key, String ... member) {
        String command = "srem";
        return this.instrumented(command, () -> this.delegated.srem(key, member));
    }

    public Response<Long> srem(byte[] key, byte[] ... member) {
        String command = "srem";
        return this.instrumented(command, () -> this.delegated.srem(key, member));
    }

    public Response<Long> strlen(String key) {
        String command = "strlen";
        return this.instrumented(command, () -> this.delegated.strlen(key));
    }

    public Response<Long> strlen(byte[] key) {
        String command = "strlen";
        return this.instrumented(command, () -> this.delegated.strlen(key));
    }

    public Response<String> substr(String key, int start, int end) {
        String command = "substr";
        return this.instrumented(command, () -> this.delegated.substr(key, start, end));
    }

    public Response<String> substr(byte[] key, int start, int end) {
        String command = "substr";
        return this.instrumented(command, () -> this.delegated.substr(key, start, end));
    }

    public Response<Long> ttl(String key) {
        String command = "ttl";
        return this.instrumented(command, () -> this.delegated.ttl(key));
    }

    public Response<Long> ttl(byte[] key) {
        String command = "ttl";
        return this.instrumented(command, () -> this.delegated.ttl(key));
    }

    public Response<String> type(String key) {
        String command = "type";
        return this.instrumented(command, () -> this.delegated.type(key));
    }

    public Response<String> type(byte[] key) {
        String command = "type";
        return this.instrumented(command, () -> this.delegated.type(key));
    }

    public Response<Long> zadd(String key, double score, String member) {
        String command = "zadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.zadd(key, score, member));
    }

    public Response<Long> zadd(String key, double score, String member, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.zadd(key, score, member, params));
    }

    public Response<Long> zadd(String key, Map<String, Double> scoreMembers) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers));
    }

    public Response<Long> zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers, params));
    }

    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        String command = "zadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.zadd(key, score, member));
    }

    public Response<Long> zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.zadd(key, score, member, params));
    }

    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers));
    }

    public Response<Long> zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers, params));
    }

    public Response<Long> zcard(String key) {
        String command = "zcard";
        return this.instrumented(command, () -> this.delegated.zcard(key));
    }

    public Response<Long> zcard(byte[] key) {
        String command = "zcard";
        return this.instrumented(command, () -> this.delegated.zcard(key));
    }

    public Response<Long> zcount(String key, double min, double max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Response<Long> zcount(String key, String min, String max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Response<Long> zcount(byte[] key, double min, double max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Response<Long> zcount(byte[] key, byte[] min, byte[] max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Response<Double> zincrby(String key, double score, String member) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member));
    }

    public Response<Double> zincrby(String key, double score, String member, ZIncrByParams params) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member, params));
    }

    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member));
    }

    public Response<Double> zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member, params));
    }

    public Response<Set<String>> zrange(String key, long start, long end) {
        String command = "zrange";
        return this.instrumented(command, () -> this.delegated.zrange(key, start, end));
    }

    public Response<Set<byte[]>> zrange(byte[] key, long start, long end) {
        String command = "zrange";
        return this.instrumented(command, () -> this.delegated.zrange(key, start, end));
    }

    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Response<Set<String>> zrangeByScore(String key, String min, String max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Response<Set<String>> zrevrangeByScore(String key, double max, double min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Response<Set<String>> zrevrangeByScore(String key, String max, String min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Response<Set<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Response<Set<String>> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Response<Set<Tuple>> zrangeWithScores(String key, long start, long end) {
        String command = "zrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeWithScores(key, start, end));
    }

    public Response<Set<Tuple>> zrangeWithScores(byte[] key, long start, long end) {
        String command = "zrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeWithScores(key, start, end));
    }

    public Response<Long> zrank(String key, String member) {
        String command = "zrank";
        return this.instrumented(command, () -> this.delegated.zrank(key, member));
    }

    public Response<Long> zrank(byte[] key, byte[] member) {
        String command = "zrank";
        return this.instrumented(command, () -> this.delegated.zrank(key, member));
    }

    public Response<Long> zrem(String key, String ... member) {
        String command = "zrem";
        return this.instrumented(command, () -> this.delegated.zrem(key, member));
    }

    public Response<Long> zrem(byte[] key, byte[] ... member) {
        String command = "zrem";
        return this.instrumented(command, () -> this.delegated.zrem(key, member));
    }

    public Response<Long> zremrangeByRank(String key, long start, long end) {
        String command = "zremrangeByRank";
        return this.instrumented(command, () -> this.delegated.zremrangeByRank(key, start, end));
    }

    public Response<Long> zremrangeByRank(byte[] key, long start, long end) {
        String command = "zremrangeByRank";
        return this.instrumented(command, () -> this.delegated.zremrangeByRank(key, start, end));
    }

    public Response<Long> zremrangeByScore(String key, double start, double end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Response<Long> zremrangeByScore(String key, String start, String end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Response<Long> zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Response<Set<String>> zrevrange(String key, long start, long end) {
        String command = "zrevrange";
        return this.instrumented(command, () -> this.delegated.zrevrange(key, start, end));
    }

    public Response<Set<byte[]>> zrevrange(byte[] key, long start, long end) {
        String command = "zrevrange";
        return this.instrumented(command, () -> this.delegated.zrevrange(key, start, end));
    }

    public Response<Set<Tuple>> zrevrangeWithScores(String key, long start, long end) {
        String command = "zrevrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeWithScores(key, start, end));
    }

    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, long start, long end) {
        String command = "zrevrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeWithScores(key, start, end));
    }

    public Response<Long> zrevrank(String key, String member) {
        String command = "zrevrank";
        return this.instrumented(command, () -> this.delegated.zrevrank(key, member));
    }

    public Response<Long> zrevrank(byte[] key, byte[] member) {
        String command = "zrevrank";
        return this.instrumented(command, () -> this.delegated.zrevrank(key, member));
    }

    public Response<Double> zscore(String key, String member) {
        String command = "zscore";
        return this.instrumented(command, () -> this.delegated.zscore(key, member));
    }

    public Response<Double> zscore(byte[] key, byte[] member) {
        String command = "zscore";
        return this.instrumented(command, () -> this.delegated.zscore(key, member));
    }

    public Response<Long> zlexcount(byte[] key, byte[] min, byte[] max) {
        String command = "zlexcount";
        return this.instrumented(command, () -> this.delegated.zlexcount(key, min, max));
    }

    public Response<Long> zlexcount(String key, String min, String max) {
        String command = "zlexcount";
        return this.instrumented(command, () -> this.delegated.zlexcount(key, min, max));
    }

    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max));
    }

    public Response<Set<String>> zrangeByLex(String key, String min, String max) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max));
    }

    public Response<Set<byte[]>> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max, offset, count));
    }

    public Response<Set<String>> zrangeByLex(String key, String min, String max, int offset, int count) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max, offset, count));
    }

    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min));
    }

    public Response<Set<String>> zrevrangeByLex(String key, String max, String min) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min));
    }

    public Response<Set<byte[]>> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min, offset, count));
    }

    public Response<Set<String>> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min, offset, count));
    }

    public Response<Long> zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        String command = "zremrangeByLex";
        return this.instrumented(command, () -> this.delegated.zremrangeByLex(key, min, max));
    }

    public Response<Long> zremrangeByLex(String key, String min, String max) {
        String command = "zremrangeByLex";
        return this.instrumented(command, () -> this.delegated.zremrangeByLex(key, min, max));
    }

    public Response<Long> bitcount(String key) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key));
    }

    public Response<Long> bitcount(String key, long start, long end) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key, start, end));
    }

    public Response<Long> bitcount(byte[] key) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key));
    }

    public Response<Long> bitcount(byte[] key, long start, long end) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key, start, end));
    }

    public Response<byte[]> dump(String key) {
        String command = "dump";
        return this.instrumented(command, () -> this.delegated.dump(key));
    }

    public Response<byte[]> dump(byte[] key) {
        String command = "dump";
        return this.instrumented(command, () -> this.delegated.dump(key));
    }

    public Response<String> migrate(String host, int port, String key, int destinationDb, int timeout) {
        String command = "migrate";
        return this.instrumented(command, () -> this.delegated.migrate(host, port, key, destinationDb, timeout));
    }

    public Response<String> migrate(String host, int port, byte[] key, int destinationDb, int timeout) {
        String command = "migrate";
        return this.instrumented(command, () -> this.delegated.migrate(host, port, key, destinationDb, timeout));
    }

    public Response<Long> objectRefcount(String key) {
        String command = "objectRefcount";
        return this.instrumented(command, () -> this.delegated.objectRefcount(key));
    }

    public Response<Long> objectRefcount(byte[] key) {
        String command = "objectRefcount";
        return this.instrumented(command, () -> this.delegated.objectRefcount(key));
    }

    public Response<String> objectEncoding(String key) {
        String command = "objectEncoding";
        return this.instrumented(command, () -> this.delegated.objectEncoding(key));
    }

    public Response<byte[]> objectEncoding(byte[] key) {
        String command = "objectEncoding";
        return this.instrumented(command, () -> this.delegated.objectEncoding(key));
    }

    public Response<Long> objectIdletime(String key) {
        String command = "objectIdletime";
        return this.instrumented(command, () -> this.delegated.objectIdletime(key));
    }

    public Response<Long> objectIdletime(byte[] key) {
        String command = "objectIdletime";
        return this.instrumented(command, () -> this.delegated.objectIdletime(key));
    }

    public Response<Long> pexpire(String key, long milliseconds) {
        String command = "pexpire";
        return this.instrumented(command, () -> this.delegated.pexpire(key, milliseconds));
    }

    public Response<Long> pexpire(byte[] key, long milliseconds) {
        String command = "pexpire";
        return this.instrumented(command, () -> this.delegated.pexpire(key, milliseconds));
    }

    public Response<Long> pexpireAt(String key, long millisecondsTimestamp) {
        String command = "pexpireAt";
        return this.instrumented(command, () -> this.delegated.pexpireAt(key, millisecondsTimestamp));
    }

    public Response<Long> pexpireAt(byte[] key, long millisecondsTimestamp) {
        String command = "pexpireAt";
        return this.instrumented(command, () -> this.delegated.pexpireAt(key, millisecondsTimestamp));
    }

    public Response<Long> pttl(String key) {
        String command = "pttl";
        return this.instrumented(command, () -> this.delegated.pttl(key));
    }

    public Response<Long> pttl(byte[] key) {
        String command = "pttl";
        return this.instrumented(command, () -> this.delegated.pttl(key));
    }

    public Response<String> restore(String key, int ttl, byte[] serializedValue) {
        String command = "restore";
        return this.instrumented(command, () -> this.delegated.restore(key, ttl, serializedValue));
    }

    public Response<String> restore(byte[] key, int ttl, byte[] serializedValue) {
        String command = "restore";
        return this.instrumented(command, () -> this.delegated.restore(key, ttl, serializedValue));
    }

    public Response<Double> incrByFloat(String key, double increment) {
        String command = "incrByFloat";
        return this.instrumented(command, () -> this.delegated.incrByFloat(key, increment));
    }

    public Response<Double> incrByFloat(byte[] key, double increment) {
        String command = "incrByFloat";
        return this.instrumented(command, () -> this.delegated.incrByFloat(key, increment));
    }

    public Response<String> psetex(String key, long milliseconds, String value) {
        String command = "psetex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.psetex(key, milliseconds, value));
    }

    public Response<String> psetex(byte[] key, long milliseconds, byte[] value) {
        String command = "psetex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.psetex(key, milliseconds, value));
    }

    public Response<String> set(String key, String value, SetParams params) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value, params));
    }

    public Response<String> set(byte[] key, byte[] value, SetParams params) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value, params));
    }

    public Response<Double> hincrByFloat(String key, String field, double increment) {
        String command = "hincrByFloat";
        return this.instrumented(command, () -> this.delegated.hincrByFloat(key, field, increment));
    }

    public Response<Double> hincrByFloat(byte[] key, byte[] field, double increment) {
        String command = "hincrByFloat";
        return this.instrumented(command, () -> this.delegated.hincrByFloat(key, field, increment));
    }

    public Response<Object> eval(String script) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.eval(script));
    }

    public Response<Object> eval(String script, List<String> keys, List<String> args) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(args), () -> this.delegated.eval(script, keys, args));
    }

    public Response<Object> eval(String script, int numKeys, String ... args) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(args), () -> this.delegated.eval(script, numKeys, args));
    }

    public Response<Object> evalsha(String script) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.evalsha(script));
    }

    public Response<Object> evalsha(String sha1, List<String> keys, List<String> args) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(args), () -> this.delegated.evalsha(sha1, keys, args));
    }

    public Response<Object> evalsha(String sha1, int numKeys, String ... args) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(args), () -> this.delegated.evalsha(sha1, numKeys, args));
    }

    public Response<Long> pfadd(byte[] key, byte[] ... elements) {
        String command = "pfadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(elements), () -> this.delegated.pfadd(key, elements));
    }

    public Response<Long> pfcount(byte[] key) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(key));
    }

    public Response<Long> pfadd(String key, String ... elements) {
        String command = "pfadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(elements), () -> this.delegated.pfadd(key, elements));
    }

    public Response<Long> pfcount(String key) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(key));
    }

    public Response<Long> geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, longitude, latitude, member));
    }

    public Response<Long> geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, memberCoordinateMap));
    }

    public Response<Long> geoadd(String key, double longitude, double latitude, String member) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, longitude, latitude, member));
    }

    public Response<Long> geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, memberCoordinateMap));
    }

    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2));
    }

    public Response<Double> geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2, unit));
    }

    public Response<Double> geodist(String key, String member1, String member2) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2));
    }

    public Response<Double> geodist(String key, String member1, String member2, GeoUnit unit) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2, unit));
    }

    public Response<List<byte[]>> geohash(byte[] key, byte[] ... members) {
        String command = "geohash";
        return this.instrumented(command, () -> this.delegated.geohash(key, members));
    }

    public Response<List<String>> geohash(String key, String ... members) {
        String command = "geohash";
        return this.instrumented(command, () -> this.delegated.geohash(key, members));
    }

    public Response<List<GeoCoordinate>> geopos(byte[] key, byte[] ... members) {
        String command = "geopos";
        return this.instrumented(command, () -> this.delegated.geopos(key, members));
    }

    public Response<List<GeoCoordinate>> geopos(String key, String ... members) {
        String command = "geopos";
        return this.instrumented(command, () -> this.delegated.geopos(key, members));
    }

    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit));
    }

    public Response<List<GeoRadiusResponse>> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit, param));
    }

    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit));
    }

    public Response<List<GeoRadiusResponse>> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit, param));
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit));
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit, param));
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit));
    }

    public Response<List<GeoRadiusResponse>> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit, param));
    }

    public Response<List<Long>> bitfield(String key, String ... elements) {
        String command = "bitfield";
        return this.instrumented(command, () -> this.delegated.bitfield(key, elements));
    }

    public Response<List<Long>> bitfield(byte[] key, byte[] ... elements) {
        String command = "bitfield";
        return this.instrumented(command, () -> this.delegated.bitfield(key, elements));
    }
}

