/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.RedisScanResult;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.MultiKeyCommands;
import redis.clients.jedis.commands.RedisPipeline;
import redis.clients.jedis.commands.ScriptingCommands;
import redis.clients.jedis.util.Pool;

public class JedisClientDelegate
implements RedisClientDelegate {
    private final String name;
    private final Pool<Jedis> jedisPool;

    public JedisClientDelegate(Pool<Jedis> jedisPool) {
        this("default", jedisPool);
    }

    public JedisClientDelegate(String name, Pool<Jedis> jedisPool) {
        this.name = name;
        this.jedisPool = jedisPool;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <R> R withCommandsClient(Function<JedisCommands, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply((JedisCommands)jedis);
            return r;
        }
    }

    @Override
    public void withCommandsClient(Consumer<JedisCommands> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept((JedisCommands)jedis);
        }
    }

    @Override
    public <R> R withMultiClient(Function<MultiKeyCommands, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply((MultiKeyCommands)jedis);
            return r;
        }
    }

    @Override
    public void withMultiClient(Consumer<MultiKeyCommands> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept((MultiKeyCommands)jedis);
        }
    }

    @Override
    public <R> R withBinaryClient(Function<BinaryJedisCommands, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply((BinaryJedisCommands)jedis);
            return r;
        }
    }

    @Override
    public void withBinaryClient(Consumer<BinaryJedisCommands> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept((BinaryJedisCommands)jedis);
        }
    }

    @Override
    public void withPipeline(Consumer<RedisPipeline> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept((RedisPipeline)jedis.pipelined());
        }
    }

    @Override
    public <R> R withPipeline(Function<RedisPipeline, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply((RedisPipeline)jedis.pipelined());
            return r;
        }
    }

    @Override
    public void syncPipeline(RedisPipeline p) {
        if (!(p instanceof Pipeline)) {
            throw new IllegalArgumentException("Invalid RedisPipeline implementation: " + p.getClass().getName());
        }
        ((Pipeline)p).sync();
    }

    @Override
    public boolean supportsMultiKeyPipelines() {
        return true;
    }

    @Override
    public void withMultiKeyPipeline(Consumer<Pipeline> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept(jedis.pipelined());
        }
    }

    @Override
    public <R> R withMultiKeyPipeline(Function<Pipeline, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply(jedis.pipelined());
            return r;
        }
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public void withTransaction(Consumer<Transaction> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept(jedis.multi());
        }
    }

    @Override
    public <R> R withTransaction(Function<Transaction, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply(jedis.multi());
            return r;
        }
    }

    @Override
    public boolean supportsScripting() {
        return true;
    }

    @Override
    public void withScriptingClient(Consumer<ScriptingCommands> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            f.accept((ScriptingCommands)jedis);
        }
    }

    @Override
    public <R> R withScriptingClient(Function<ScriptingCommands, R> f) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            R r = f.apply((ScriptingCommands)jedis);
            return r;
        }
    }

    @Override
    public void withKeyScan(String pattern, int count, Consumer<RedisScanResult> f) {
        ScanParams params = new ScanParams().match(pattern).count(Integer.valueOf(count));
        String cursor = ScanParams.SCAN_POINTER_START;
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            ScanResult result;
            do {
                result = jedis.scan(cursor, params);
                List results = result.getResult();
                f.accept(() -> results);
            } while (!"0".equals(cursor = result.getCursor()));
        }
    }
}

