/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.netflix.spectator.api.NoopRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.jedis.JedisDriverProperties;
import com.netflix.spinnaker.kork.jedis.RedisClientConnectionProperties;
import com.netflix.spinnaker.kork.jedis.exception.MissingRequiredConfiguration;
import com.netflix.spinnaker.kork.jedis.telemetry.InstrumentedJedisPool;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.Pool;

public class JedisPoolFactory {
    private final Registry registry;

    public JedisPoolFactory() {
        this((Registry)new NoopRegistry());
    }

    public JedisPoolFactory(Registry registry) {
        this.registry = registry;
    }

    public Pool<Jedis> build(String name, JedisDriverProperties properties, GenericObjectPoolConfig objectPoolConfig) {
        if (properties.connection == null || "".equals(properties.connection)) {
            throw new MissingRequiredConfiguration("Jedis client must have a connection defined");
        }
        RedisClientConnectionProperties cxp = new RedisClientConnectionProperties(URI.create(properties.connection));
        GenericObjectPoolConfig poolConfig = Optional.ofNullable(properties.poolConfig).orElse(objectPoolConfig);
        return new InstrumentedJedisPool(this.registry, new JedisPool(poolConfig, cxp.addr(), cxp.port(), properties.timeoutMs, cxp.password(), cxp.database(), null, cxp.isSSL()), name);
    }
}

