/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis.telemetry;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.jedis.telemetry.InstrumentedJedis;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class InstrumentedJedisPool
extends JedisPool {
    private final Registry registry;
    private final JedisPool delegated;
    private final String poolName;
    private GenericObjectPool<Jedis> delegateInternalPool;

    public InstrumentedJedisPool(Registry registry, JedisPool delegated) {
        this(registry, delegated, "unnamed");
    }

    public InstrumentedJedisPool(Registry registry, JedisPool delegated, String poolName) {
        this.registry = registry;
        this.delegated = delegated;
        this.poolName = poolName;
    }

    public GenericObjectPool<Jedis> getInternalPoolReference() {
        if (this.delegateInternalPool == null) {
            try {
                Field f = FieldUtils.getField(this.delegated.getClass(), (String)"internalPool", (boolean)true);
                if (Objects.isNull(f)) {
                    throw new IllegalStateException("Could not get reference to delegate's internal pool");
                }
                this.delegateInternalPool = (GenericObjectPool)f.get(this.delegated);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not get reference to delegate's internal pool", e);
            }
        }
        return this.delegateInternalPool;
    }

    public Jedis getResource() {
        return new InstrumentedJedis(this.registry, this.delegated.getResource(), this.poolName);
    }

    public void returnResourceObject(Jedis resource) {
        super.returnResourceObject((Object)this.unwrapResource(resource));
    }

    protected void returnBrokenResourceObject(Jedis resource) {
        super.returnBrokenResourceObject((Object)this.unwrapResource(resource));
    }

    public void close() {
        this.delegated.close();
    }

    public boolean isClosed() {
        return this.delegated.isClosed();
    }

    public void initPool(GenericObjectPoolConfig poolConfig, PooledObjectFactory<Jedis> factory) {
    }

    public void destroy() {
        this.delegated.destroy();
    }

    protected void closeInternalPool() {
    }

    public int getNumActive() {
        return this.getInternalPoolReference().getNumActive();
    }

    public int getNumIdle() {
        return this.getInternalPoolReference().getNumIdle();
    }

    public int getNumWaiters() {
        return this.getInternalPoolReference().getNumWaiters();
    }

    public long getMeanBorrowWaitTimeMillis() {
        return this.getInternalPoolReference().getMeanBorrowWaitTimeMillis();
    }

    public long getMaxBorrowWaitTimeMillis() {
        return this.getInternalPoolReference().getMaxBorrowWaitTimeMillis();
    }

    public void addObjects(int count) {
        this.delegated.addObjects(count);
    }

    private Jedis unwrapResource(Jedis jedis) {
        if (jedis instanceof InstrumentedJedis) {
            return ((InstrumentedJedis)jedis).unwrap();
        }
        return jedis;
    }
}

