/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.exception.RedisClientNotFound;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisClientSelector {
    private static final String DEFAULT = "default";
    private static final String PRIMARY = "primary";
    private static final String PREVIOUS = "previous";
    private final Logger log = LoggerFactory.getLogger(RedisClientSelector.class);
    private final List<RedisClientDelegate> clients;

    public RedisClientSelector(List<RedisClientDelegate> clients) {
        this.clients = clients;
        clients.forEach(client -> this.log.info("Configured {} using {}", (Object)client.name(), (Object)client.getClass().getSimpleName()));
    }

    public RedisClientDelegate primary(String name) {
        return this.primary(name, true);
    }

    public Optional<RedisClientDelegate> previous(String name) {
        return this.previous(name, true);
    }

    public RedisClientDelegate primary(String name, boolean fallbackToDefault) {
        return this.select(name, true, fallbackToDefault).orElseThrow(() -> new RedisClientNotFound("Could not find primary Redis client by name '" + name + "' and no default configured"));
    }

    public Optional<RedisClientDelegate> previous(String name, boolean fallbackToDefault) {
        return this.select(name, false, fallbackToDefault);
    }

    private Optional<RedisClientDelegate> select(String name, boolean primary, boolean fallbackToDefault) {
        String stdName = RedisClientSelector.getName(primary, name);
        Optional<RedisClientDelegate> client = this.clients.stream().filter(it -> stdName.equals(it.name())).findFirst();
        if (!client.isPresent() && fallbackToDefault) {
            String defaultName = RedisClientSelector.getName(primary, DEFAULT);
            client = this.clients.stream().filter(it -> defaultName.equals(it.name())).findFirst();
        }
        return client;
    }

    public static String getName(boolean primary, String name) {
        return (primary ? PRIMARY : PREVIOUS) + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

