/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis.telemetry;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileDistributionSummary;
import com.netflix.spectator.api.histogram.PercentileTimer;
import com.netflix.spinnaker.kork.jedis.telemetry.InstrumentedJedisException;
import com.netflix.spinnaker.kork.jedis.telemetry.InstrumentedPipeline;
import com.netflix.spinnaker.kork.jedis.telemetry.TelemetryHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Client;
import redis.clients.jedis.ClusterReset;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.Slowlog;

public class InstrumentedJedis
extends Jedis {
    private final Registry registry;
    private final Jedis delegated;
    private final String poolName;

    public InstrumentedJedis(Registry registry, Jedis delegated) {
        this(registry, delegated, "unnamed");
    }

    public InstrumentedJedis(Registry registry, Jedis delegated, String poolName) {
        this.registry = registry;
        this.delegated = delegated;
        this.poolName = poolName;
    }

    public Jedis unwrap() {
        return this.delegated;
    }

    private <T> T instrumented(String command, Callable<T> action) {
        return this.internalInstrumented(command, Optional.empty(), action);
    }

    private <T> T instrumented(String command, long payloadSize, Callable<T> action) {
        return this.internalInstrumented(command, Optional.of(payloadSize), action);
    }

    private <T> T internalInstrumented(String command, Optional<Long> payloadSize, Callable<T> action) {
        payloadSize.ifPresent(size -> PercentileDistributionSummary.get((Registry)this.registry, (Id)TelemetryHelper.payloadSizeId(this.registry, this.poolName, command, false)).record(size.longValue()));
        try {
            return (T)PercentileTimer.get((Registry)this.registry, (Id)TelemetryHelper.timerId(this.registry, this.poolName, command, false)).record(() -> {
                Object result = action.call();
                this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, false, true)).increment();
                return result;
            });
        }
        catch (Exception e) {
            this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, false, false)).increment();
            throw new InstrumentedJedisException("could not execute delegate function", e);
        }
    }

    private void instrumented(String command, Runnable action) {
        this.internalInstrumented(command, Optional.empty(), action);
    }

    private void instrumented(String command, long payloadSize, Runnable action) {
        this.internalInstrumented(command, Optional.of(payloadSize), action);
    }

    private void internalInstrumented(String command, Optional<Long> payloadSize, Runnable action) {
        payloadSize.ifPresent(size -> PercentileDistributionSummary.get((Registry)this.registry, (Id)TelemetryHelper.payloadSizeId(this.registry, this.poolName, command, false)).record(size.longValue()));
        try {
            PercentileTimer.get((Registry)this.registry, (Id)TelemetryHelper.timerId(this.registry, this.poolName, command, false)).record(() -> {
                action.run();
                this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, false, true)).increment();
            });
        }
        catch (Exception e) {
            this.registry.counter(TelemetryHelper.invocationId(this.registry, this.poolName, command, false, false)).increment();
            throw new InstrumentedJedisException("could not execute delegate function", e);
        }
    }

    public String set(String key, String value) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value));
    }

    public String set(String key, String value, SetParams params) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value, params));
    }

    public String get(String key) {
        String command = "get";
        return this.instrumented(command, () -> this.delegated.get(key));
    }

    public Long exists(String ... keys) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(keys));
    }

    public Boolean exists(String key) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(key));
    }

    public Long del(String ... keys) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(keys));
    }

    public Long del(String key) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(key));
    }

    public String type(String key) {
        String command = "type";
        return this.instrumented(command, () -> this.delegated.type(key));
    }

    public Set<String> keys(String pattern) {
        String command = "keys";
        return this.instrumented(command, () -> this.delegated.keys(pattern));
    }

    public String randomKey() {
        String command = "randomKey";
        return this.instrumented(command, () -> this.delegated.randomKey());
    }

    public String rename(String oldkey, String newkey) {
        String command = "rename";
        return this.instrumented(command, () -> this.delegated.rename(oldkey, newkey));
    }

    public Long renamenx(String oldkey, String newkey) {
        String command = "renamenx";
        return this.instrumented(command, () -> this.delegated.renamenx(oldkey, newkey));
    }

    public Long expire(String key, int seconds) {
        String command = "expire";
        return this.instrumented(command, () -> this.delegated.expire(key, seconds));
    }

    public Long expireAt(String key, long unixTime) {
        String command = "expireAt";
        return this.instrumented(command, () -> this.delegated.expireAt(key, unixTime));
    }

    public Long ttl(String key) {
        String command = "ttl";
        return this.instrumented(command, () -> this.delegated.ttl(key));
    }

    public Long move(String key, int dbIndex) {
        String command = "move";
        return this.instrumented(command, () -> this.delegated.move(key, dbIndex));
    }

    public String getSet(String key, String value) {
        String command = "getSet";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.getSet(key, value));
    }

    public List<String> mget(String ... keys) {
        String command = "mget";
        return this.instrumented(command, () -> this.delegated.mget(keys));
    }

    public Long setnx(String key, String value) {
        String command = "setnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setnx(key, value));
    }

    public String setex(String key, int seconds, String value) {
        String command = "setex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setex(key, seconds, value));
    }

    public String mset(String ... keysvalues) {
        String command = "mset";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.mset(keysvalues));
    }

    public Long msetnx(String ... keysvalues) {
        String command = "msetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.msetnx(keysvalues));
    }

    public Long decrBy(String key, long integer) {
        String command = "decrBy";
        return this.instrumented(command, () -> this.delegated.decrBy(key, integer));
    }

    public Long decr(String key) {
        String command = "decr";
        return this.instrumented(command, () -> this.delegated.decr(key));
    }

    public Long incrBy(String key, long integer) {
        String command = "incrBy";
        return this.instrumented(command, () -> this.delegated.incrBy(key, integer));
    }

    public Double incrByFloat(String key, double value) {
        String command = "incrByFloat";
        return this.instrumented(command, () -> this.delegated.incrByFloat(key, value));
    }

    public Long incr(String key) {
        String command = "incr";
        return this.instrumented(command, () -> this.delegated.incr(key));
    }

    public Long append(String key, String value) {
        String command = "append";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.append(key, value));
    }

    public String substr(String key, int start, int end) {
        String command = "substr";
        return this.instrumented(command, () -> this.delegated.substr(key, start, end));
    }

    public Long hset(String key, String field, String value) {
        String command = "hset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hset(key, field, value));
    }

    public String hget(String key, String field) {
        String command = "hget";
        return this.instrumented(command, () -> this.delegated.hget(key, field));
    }

    public Long hsetnx(String key, String field, String value) {
        String command = "hsetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hsetnx(key, field, value));
    }

    public String hmset(String key, Map<String, String> hash) {
        String command = "hmset";
        return this.instrumented(command, TelemetryHelper.payloadSize(hash), () -> this.delegated.hmset(key, hash));
    }

    public List<String> hmget(String key, String ... fields) {
        String command = "hmget";
        return this.instrumented(command, () -> this.delegated.hmget(key, fields));
    }

    public Long hincrBy(String key, String field, long value) {
        String command = "hincrBy";
        return this.instrumented(command, () -> this.delegated.hincrBy(key, field, value));
    }

    public Double hincrByFloat(String key, String field, double value) {
        String command = "hincrByFloat";
        return this.instrumented(command, () -> this.delegated.hincrByFloat(key, field, value));
    }

    public Boolean hexists(String key, String field) {
        String command = "hexists";
        return this.instrumented(command, () -> this.delegated.hexists(key, field));
    }

    public Long hdel(String key, String ... fields) {
        String command = "hdel";
        return this.instrumented(command, () -> this.delegated.hdel(key, fields));
    }

    public Long hlen(String key) {
        String command = "hlen";
        return this.instrumented(command, () -> this.delegated.hlen(key));
    }

    public Set<String> hkeys(String key) {
        String command = "hkeys";
        return this.instrumented(command, () -> this.delegated.hkeys(key));
    }

    public List<String> hvals(String key) {
        String command = "hvals";
        return this.instrumented(command, () -> this.delegated.hvals(key));
    }

    public Map<String, String> hgetAll(String key) {
        String command = "hgetAll";
        return this.instrumented(command, () -> this.delegated.hgetAll(key));
    }

    public Long rpush(String key, String ... strings) {
        String command = "rpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(strings), () -> this.delegated.rpush(key, strings));
    }

    public Long lpush(String key, String ... strings) {
        String command = "lpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(strings), () -> this.delegated.lpush(key, strings));
    }

    public Long llen(String key) {
        String command = "llen";
        return this.instrumented(command, () -> this.delegated.llen(key));
    }

    public List<String> lrange(String key, long start, long end) {
        String command = "lrange";
        return this.instrumented(command, () -> this.delegated.lrange(key, start, end));
    }

    public String ltrim(String key, long start, long end) {
        String command = "ltrim";
        return this.instrumented(command, () -> this.delegated.ltrim(key, start, end));
    }

    public String lindex(String key, long index) {
        String command = "lindex";
        return this.instrumented(command, () -> this.delegated.lindex(key, index));
    }

    public String lset(String key, long index, String value) {
        String command = "lset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lset(key, index, value));
    }

    public Long lrem(String key, long count, String value) {
        String command = "lrem";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lrem(key, count, value));
    }

    public String lpop(String key) {
        String command = "lpop";
        return this.instrumented(command, () -> this.delegated.lpop(key));
    }

    public String rpop(String key) {
        String command = "rpop";
        return this.instrumented(command, () -> this.delegated.rpop(key));
    }

    public String rpoplpush(String srckey, String dstkey) {
        String command = "rpoplpush";
        return this.instrumented(command, () -> this.delegated.rpoplpush(srckey, dstkey));
    }

    public Long sadd(String key, String ... members) {
        String command = "sadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(members), () -> this.delegated.sadd(key, members));
    }

    public Set<String> smembers(String key) {
        String command = "smembers";
        return this.instrumented(command, () -> this.delegated.smembers(key));
    }

    public Long srem(String key, String ... members) {
        String command = "srem";
        return this.instrumented(command, TelemetryHelper.payloadSize(members), () -> this.delegated.srem(key, members));
    }

    public String spop(String key) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key));
    }

    public Set<String> spop(String key, long count) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key, count));
    }

    public Long smove(String srckey, String dstkey, String member) {
        String command = "smove";
        return this.instrumented(command, () -> this.delegated.smove(srckey, dstkey, member));
    }

    public Long scard(String key) {
        String command = "scard";
        return this.instrumented(command, () -> this.delegated.scard(key));
    }

    public Boolean sismember(String key, String member) {
        String command = "sismember";
        return this.instrumented(command, () -> this.delegated.sismember(key, member));
    }

    public Set<String> sinter(String ... keys) {
        String command = "sinter";
        return this.instrumented(command, () -> this.delegated.sinter(keys));
    }

    public Long sinterstore(String dstkey, String ... keys) {
        String command = "sinterstore";
        return this.instrumented(command, () -> this.delegated.sinterstore(dstkey, keys));
    }

    public Set<String> sunion(String ... keys) {
        String command = "sunion";
        return this.instrumented(command, () -> this.delegated.sunion(keys));
    }

    public Long sunionstore(String dstkey, String ... keys) {
        String command = "sunionstore";
        return this.instrumented(command, () -> this.delegated.sunionstore(dstkey, keys));
    }

    public Set<String> sdiff(String ... keys) {
        String command = "sdiff";
        return this.instrumented(command, () -> this.delegated.sdiff(keys));
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        String command = "sdiffstore";
        return this.instrumented(command, () -> this.delegated.sdiffstore(dstkey, keys));
    }

    public String srandmember(String key) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key));
    }

    public List<String> srandmember(String key, int count) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key, count));
    }

    public Long zadd(String key, double score, String member) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, score, member));
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, score, member, params));
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers));
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers, params));
    }

    public Set<String> zrange(String key, long start, long end) {
        String command = "zrange";
        return this.instrumented(command, () -> this.delegated.zrange(key, start, end));
    }

    public Long zrem(String key, String ... members) {
        String command = "zrem";
        return this.instrumented(command, () -> this.delegated.zrem(key, members));
    }

    public Double zincrby(String key, double score, String member) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member));
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member, params));
    }

    public Long zrank(String key, String member) {
        String command = "zrank";
        return this.instrumented(command, () -> this.delegated.zrank(key, member));
    }

    public Long zrevrank(String key, String member) {
        String command = "zrevrank";
        return this.instrumented(command, () -> this.delegated.zrevrank(key, member));
    }

    public Set<String> zrevrange(String key, long start, long end) {
        String command = "zrevrange";
        return this.instrumented(command, () -> this.delegated.zrevrange(key, start, end));
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        String command = "zrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeWithScores(key, start, end));
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        String command = "zrevrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeWithScores(key, start, end));
    }

    public Long zcard(String key) {
        String command = "zcard";
        return this.instrumented(command, () -> this.delegated.zcard(key));
    }

    public Double zscore(String key, String member) {
        String command = "zscore";
        return this.instrumented(command, () -> this.delegated.zscore(key, member));
    }

    public String watch(String ... keys) {
        String command = "watch";
        return this.instrumented(command, () -> this.delegated.watch(keys));
    }

    public List<String> sort(String key) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key));
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters));
    }

    public List<String> blpop(int timeout, String ... keys) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(timeout, keys));
    }

    public List<String> blpop(String ... args) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(args));
    }

    public List<String> brpop(String ... args) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(args));
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters, dstkey));
    }

    public Long sort(String key, String dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, dstkey));
    }

    public List<String> brpop(int timeout, String ... keys) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(timeout, keys));
    }

    public Long zcount(String key, double min, double max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Long zcount(String key, String min, String max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Long zremrangeByRank(String key, long start, long end) {
        String command = "zremrangeByRank";
        return this.instrumented(command, () -> this.delegated.zremrangeByRank(key, start, end));
    }

    public Long zremrangeByScore(String key, double start, double end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Long zremrangeByScore(String key, String start, String end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Long zunionstore(String dstkey, String ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, sets));
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, params, sets));
    }

    public Long zinterstore(String dstkey, String ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, sets));
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, params, sets));
    }

    public Long zlexcount(String key, String min, String max) {
        String command = "zlexcount";
        return this.instrumented(command, () -> this.delegated.zlexcount(key, min, max));
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max));
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max, offset, count));
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min));
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min, offset, count));
    }

    public Long zremrangeByLex(String key, String min, String max) {
        String command = "zremrangeByLex";
        return this.instrumented(command, () -> this.delegated.zremrangeByLex(key, min, max));
    }

    public Long strlen(String key) {
        String command = "strlen";
        return this.instrumented(command, () -> this.delegated.strlen(key));
    }

    public Long lpushx(String key, String ... string) {
        String command = "lpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.lpushx(key, string));
    }

    public Long persist(String key) {
        String command = "persist";
        return this.instrumented(command, () -> this.delegated.persist(key));
    }

    public Long rpushx(String key, String ... string) {
        String command = "rpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.rpushx(key, string));
    }

    public String echo(String string) {
        String command = "echo";
        return this.instrumented(command, () -> this.delegated.echo(string));
    }

    public Long linsert(String key, ListPosition where, String pivot, String value) {
        String command = "linsert";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.linsert(key, where, pivot, value));
    }

    public String brpoplpush(String source, String destination, int timeout) {
        String command = "brpoplpush";
        return this.instrumented(command, () -> this.delegated.brpoplpush(source, destination, timeout));
    }

    public Boolean setbit(String key, long offset, boolean value) {
        String command = "setbit";
        return this.instrumented(command, () -> this.delegated.setbit(key, offset, value));
    }

    public Boolean setbit(String key, long offset, String value) {
        String command = "setbit";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setbit(key, offset, value));
    }

    public Boolean getbit(String key, long offset) {
        String command = "getbit";
        return this.instrumented(command, () -> this.delegated.getbit(key, offset));
    }

    public Long setrange(String key, long offset, String value) {
        String command = "setrange";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setrange(key, offset, value));
    }

    public String getrange(String key, long startOffset, long endOffset) {
        String command = "getrange";
        return this.instrumented(command, () -> this.delegated.getrange(key, startOffset, endOffset));
    }

    public Long bitpos(String key, boolean value) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value));
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value, params));
    }

    public List<String> configGet(String pattern) {
        String command = "configGet";
        return this.instrumented(command, () -> this.delegated.configGet(pattern));
    }

    public String configSet(String parameter, String value) {
        String command = "configSet";
        return this.instrumented(command, () -> this.delegated.configSet(parameter, value));
    }

    public Object eval(String script, int keyCount, String ... params) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(params), () -> this.delegated.eval(script, keyCount, params));
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.delegated.subscribe(jedisPubSub, channels);
    }

    public Long publish(String channel, String message) {
        String command = "publish";
        return this.instrumented(command, TelemetryHelper.payloadSize(message), () -> this.delegated.publish(channel, message));
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.delegated.psubscribe(jedisPubSub, patterns);
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(args), () -> this.delegated.eval(script, keys, args));
    }

    public Object eval(String script) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.eval(script));
    }

    public Object evalsha(String script) {
        String command = "evalsha";
        return this.instrumented(command, () -> this.delegated.evalsha(script));
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(args), () -> this.delegated.evalsha(sha1, keys, args));
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(params), () -> this.delegated.evalsha(sha1, keyCount, params));
    }

    public Boolean scriptExists(String sha1) {
        String command = "scriptExists";
        return this.instrumented(command, () -> this.delegated.scriptExists(sha1));
    }

    public List<Boolean> scriptExists(String ... sha1) {
        String command = "scriptExists";
        return this.instrumented(command, () -> this.delegated.scriptExists(sha1));
    }

    public String scriptLoad(String script) {
        String command = "scriptLoad";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.scriptLoad(script));
    }

    public List<Slowlog> slowlogGet() {
        String command = "slowlogGet";
        return this.instrumented(command, () -> this.delegated.slowlogGet());
    }

    public List<Slowlog> slowlogGet(long entries) {
        String command = "slowlogGet";
        return this.instrumented(command, () -> this.delegated.slowlogGet(entries));
    }

    public Long objectRefcount(String string) {
        String command = "objectRefcount";
        return this.instrumented(command, () -> this.delegated.objectRefcount(string));
    }

    public String objectEncoding(String string) {
        String command = "objectEncoding";
        return this.instrumented(command, () -> this.delegated.objectEncoding(string));
    }

    public Long objectIdletime(String string) {
        String command = "objectIdletime";
        return this.instrumented(command, () -> this.delegated.objectIdletime(string));
    }

    public Long bitcount(String key) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key));
    }

    public Long bitcount(String key, long start, long end) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key, start, end));
    }

    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        String command = "bitop";
        return this.instrumented(command, () -> this.delegated.bitop(op, destKey, srcKeys));
    }

    public List<Map<String, String>> sentinelMasters() {
        String command = "sentinelMasters";
        return this.instrumented(command, () -> this.delegated.sentinelMasters());
    }

    public List<String> sentinelGetMasterAddrByName(String masterName) {
        String command = "sentinelGetMasterAddrByName";
        return this.instrumented(command, () -> this.delegated.sentinelGetMasterAddrByName(masterName));
    }

    public Long sentinelReset(String pattern) {
        String command = "sentinelReset";
        return this.instrumented(command, () -> this.delegated.sentinelReset(pattern));
    }

    public List<Map<String, String>> sentinelSlaves(String masterName) {
        String command = "sentinelSlaves";
        return this.instrumented(command, () -> this.delegated.sentinelSlaves(masterName));
    }

    public String sentinelFailover(String masterName) {
        String command = "sentinelFailover";
        return this.instrumented(command, () -> this.delegated.sentinelFailover(masterName));
    }

    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        String command = "sentinelMonitor";
        return this.instrumented(command, () -> this.delegated.sentinelMonitor(masterName, ip, port, quorum));
    }

    public String sentinelRemove(String masterName) {
        String command = "sentinelRemove";
        return this.instrumented(command, () -> this.delegated.sentinelRemove(masterName));
    }

    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        String command = "sentinelSet";
        return this.instrumented(command, () -> this.delegated.sentinelSet(masterName, parameterMap));
    }

    public byte[] dump(String key) {
        String command = "dump";
        return this.instrumented(command, () -> this.delegated.dump(key));
    }

    public String restore(String key, int ttl, byte[] serializedValue) {
        String command = "restore";
        return this.instrumented(command, () -> this.delegated.restore(key, ttl, serializedValue));
    }

    public Long pexpire(String key, long milliseconds) {
        String command = "pexpire";
        return this.instrumented(command, () -> this.delegated.pexpire(key, milliseconds));
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        String command = "pexpireAt";
        return this.instrumented(command, () -> this.delegated.pexpireAt(key, millisecondsTimestamp));
    }

    public Long pttl(String key) {
        String command = "pttl";
        return this.instrumented(command, () -> this.delegated.pttl(key));
    }

    public String psetex(String key, long milliseconds, String value) {
        String command = "psetex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.psetex(key, milliseconds, value));
    }

    public String clientKill(String client) {
        String command = "clientKill";
        return this.instrumented(command, () -> this.delegated.clientKill(client));
    }

    public String clientSetname(String name) {
        String command = "clientSetname";
        return this.instrumented(command, () -> this.delegated.clientSetname(name));
    }

    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        String command = "migrate";
        return this.instrumented(command, () -> this.delegated.migrate(host, port, key, destinationDb, timeout));
    }

    public ScanResult<String> scan(String cursor) {
        String command = "scan";
        return this.instrumented(command, () -> this.delegated.scan(cursor));
    }

    public ScanResult<String> scan(String cursor, ScanParams params) {
        String command = "scan";
        return this.instrumented(command, () -> this.delegated.scan(cursor, params));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        String command = "hscan";
        return this.instrumented(command, () -> this.delegated.hscan(key, cursor));
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        String command = "hscan";
        return this.instrumented(command, () -> this.delegated.hscan(key, cursor, params));
    }

    public ScanResult<String> sscan(String key, String cursor) {
        String command = "sscan";
        return this.instrumented(command, () -> this.delegated.sscan(key, cursor));
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        String command = "sscan";
        return this.instrumented(command, () -> this.delegated.sscan(key, cursor, params));
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        String command = "zscan";
        return this.instrumented(command, () -> this.delegated.zscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        String command = "zscan";
        return this.instrumented(command, () -> this.delegated.zscan(key, cursor, params));
    }

    public String clusterNodes() {
        String command = "clusterNodes";
        return this.instrumented(command, () -> this.delegated.clusterNodes());
    }

    public String readonly() {
        String command = "readonly";
        return this.instrumented(command, () -> this.delegated.readonly());
    }

    public String clusterMeet(String ip, int port) {
        String command = "clusterMeet";
        return this.instrumented(command, () -> this.delegated.clusterMeet(ip, port));
    }

    public String clusterReset(ClusterReset resetType) {
        String command = "clusterReset";
        return this.instrumented(command, () -> this.delegated.clusterReset(resetType));
    }

    public String clusterAddSlots(int ... slots) {
        String command = "clusterAddSlots";
        return this.instrumented(command, () -> this.delegated.clusterAddSlots(slots));
    }

    public String clusterDelSlots(int ... slots) {
        String command = "clusterDelSlots";
        return this.instrumented(command, () -> this.delegated.clusterDelSlots(slots));
    }

    public String clusterInfo() {
        String command = "clusterInfo";
        return this.instrumented(command, () -> this.delegated.clusterInfo());
    }

    public List<String> clusterGetKeysInSlot(int slot, int count) {
        String command = "clusterGetKeysInSlot";
        return this.instrumented(command, () -> this.delegated.clusterGetKeysInSlot(slot, count));
    }

    public String clusterSetSlotNode(int slot, String nodeId) {
        String command = "clusterSetSlotNode";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotNode(slot, nodeId));
    }

    public String clusterSetSlotMigrating(int slot, String nodeId) {
        String command = "clusterSetSlotMigrating";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotMigrating(slot, nodeId));
    }

    public String clusterSetSlotImporting(int slot, String nodeId) {
        String command = "clusterSetSlotImporting";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotImporting(slot, nodeId));
    }

    public String clusterSetSlotStable(int slot) {
        String command = "clusterSetSlotStable";
        return this.instrumented(command, () -> this.delegated.clusterSetSlotStable(slot));
    }

    public String clusterForget(String nodeId) {
        String command = "clusterForget";
        return this.instrumented(command, () -> this.delegated.clusterForget(nodeId));
    }

    public String clusterFlushSlots() {
        String command = "clusterFlushSlots";
        return this.instrumented(command, () -> this.delegated.clusterFlushSlots());
    }

    public Long clusterKeySlot(String key) {
        String command = "clusterKeySlot";
        return this.instrumented(command, () -> this.delegated.clusterKeySlot(key));
    }

    public Long clusterCountKeysInSlot(int slot) {
        String command = "clusterCountKeysInSlot";
        return this.instrumented(command, () -> this.delegated.clusterCountKeysInSlot(slot));
    }

    public String clusterSaveConfig() {
        String command = "clusterSaveConfig";
        return this.instrumented(command, () -> this.delegated.clusterSaveConfig());
    }

    public String clusterReplicate(String nodeId) {
        String command = "clusterReplicate";
        return this.instrumented(command, () -> this.delegated.clusterReplicate(nodeId));
    }

    public List<String> clusterSlaves(String nodeId) {
        String command = "clusterSlaves";
        return this.instrumented(command, () -> this.delegated.clusterSlaves(nodeId));
    }

    public String clusterFailover() {
        String command = "clusterFailover";
        return this.instrumented(command, () -> this.delegated.clusterFailover());
    }

    public List<Object> clusterSlots() {
        String command = "clusterSlots";
        return this.instrumented(command, () -> this.delegated.clusterSlots());
    }

    public String asking() {
        String command = "asking";
        return this.instrumented(command, () -> this.delegated.asking());
    }

    public List<String> pubsubChannels(String pattern) {
        String command = "pubsubChannels";
        return this.instrumented(command, () -> this.delegated.pubsubChannels(pattern));
    }

    public Long pubsubNumPat() {
        String command = "pubsubNumPat";
        return this.instrumented(command, () -> this.delegated.pubsubNumPat());
    }

    public Map<String, String> pubsubNumSub(String ... channels) {
        String command = "pubsubNumSub";
        return this.instrumented(command, () -> this.delegated.pubsubNumSub(channels));
    }

    public void close() {
        super.close();
        this.delegated.close();
    }

    public void setDataSource(JedisPoolAbstract jedisPool) {
        this.delegated.setDataSource(jedisPool);
    }

    public Long pfadd(String key, String ... elements) {
        String command = "pfadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(elements), () -> this.delegated.pfadd(key, elements));
    }

    public long pfcount(String key) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(key));
    }

    public long pfcount(String ... keys) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(keys));
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        String command = "pfmerge";
        return this.instrumented(command, () -> this.delegated.pfmerge(destkey, sourcekeys));
    }

    public List<String> blpop(int timeout, String key) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(timeout, key));
    }

    public List<String> brpop(int timeout, String key) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(timeout, key));
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        String command = "geoadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.geoadd(key, longitude, latitude, member));
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, memberCoordinateMap));
    }

    public Double geodist(String key, String member1, String member2) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2));
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2, unit));
    }

    public List<String> geohash(String key, String ... members) {
        String command = "geohash";
        return this.instrumented(command, () -> this.delegated.geohash(key, members));
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        String command = "geopos";
        return this.instrumented(command, () -> this.delegated.geopos(key, members));
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit, param));
    }

    public List<Long> bitfield(String key, String ... arguments) {
        String command = "bitfield";
        return this.instrumented(command, () -> this.delegated.bitfield(key, arguments));
    }

    public String ping() {
        String command = "ping";
        return this.instrumented(command, () -> this.delegated.ping());
    }

    public String set(byte[] key, byte[] value) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value));
    }

    public String set(byte[] key, byte[] value, SetParams params) {
        String command = "set";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.set(key, value, params));
    }

    public byte[] get(byte[] key) {
        String command = "get";
        return this.instrumented(command, () -> this.delegated.get(key));
    }

    public String quit() {
        String command = "quit";
        return this.instrumented(command, () -> this.delegated.quit());
    }

    public Long exists(byte[] ... keys) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(keys));
    }

    public Boolean exists(byte[] key) {
        String command = "exists";
        return this.instrumented(command, () -> this.delegated.exists(key));
    }

    public Long del(byte[] ... keys) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(keys));
    }

    public Long del(byte[] key) {
        String command = "del";
        return this.instrumented(command, () -> this.delegated.del(key));
    }

    public String type(byte[] key) {
        String command = "type";
        return this.instrumented(command, () -> this.delegated.type(key));
    }

    public String flushDB() {
        String command = "flushDB";
        return this.instrumented(command, () -> this.delegated.flushDB());
    }

    public Set<byte[]> keys(byte[] pattern) {
        String command = "keys";
        return this.instrumented(command, () -> this.delegated.keys(pattern));
    }

    public byte[] randomBinaryKey() {
        String command = "randomBinaryKey";
        return this.instrumented(command, () -> this.delegated.randomBinaryKey());
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        String command = "rename";
        return this.instrumented(command, () -> this.delegated.rename(oldkey, newkey));
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        String command = "renamenx";
        return this.instrumented(command, () -> this.delegated.renamenx(oldkey, newkey));
    }

    public Long dbSize() {
        String command = "dbSize";
        return this.instrumented(command, () -> this.delegated.dbSize());
    }

    public Long expire(byte[] key, int seconds) {
        String command = "expire";
        return this.instrumented(command, () -> this.delegated.expire(key, seconds));
    }

    public Long expireAt(byte[] key, long unixTime) {
        String command = "expireAt";
        return this.instrumented(command, () -> this.delegated.expireAt(key, unixTime));
    }

    public Long ttl(byte[] key) {
        String command = "ttl";
        return this.instrumented(command, () -> this.delegated.ttl(key));
    }

    public String select(int index) {
        String command = "select";
        return this.instrumented(command, () -> this.delegated.select(index));
    }

    public Long move(byte[] key, int dbIndex) {
        String command = "move";
        return this.instrumented(command, () -> this.delegated.move(key, dbIndex));
    }

    public String flushAll() {
        String command = "flushAll";
        return this.instrumented(command, () -> this.delegated.flushAll());
    }

    public byte[] getSet(byte[] key, byte[] value) {
        String command = "getSet";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.getSet(key, value));
    }

    public List<byte[]> mget(byte[] ... keys) {
        String command = "mget";
        return this.instrumented(command, () -> this.delegated.mget(keys));
    }

    public Long setnx(byte[] key, byte[] value) {
        String command = "setnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setnx(key, value));
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        String command = "setex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setex(key, seconds, value));
    }

    public String mset(byte[] ... keysvalues) {
        String command = "mset";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.mset(keysvalues));
    }

    public Long msetnx(byte[] ... keysvalues) {
        String command = "msetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(keysvalues), () -> this.delegated.msetnx(keysvalues));
    }

    public Long decrBy(byte[] key, long integer) {
        String command = "decrBy";
        return this.instrumented(command, () -> this.delegated.decrBy(key, integer));
    }

    public Long decr(byte[] key) {
        String command = "decr";
        return this.instrumented(command, () -> this.delegated.decr(key));
    }

    public Long incrBy(byte[] key, long integer) {
        String command = "incrBy";
        return this.instrumented(command, () -> this.delegated.incrBy(key, integer));
    }

    public Double incrByFloat(byte[] key, double integer) {
        String command = "incrByFloat";
        return this.instrumented(command, () -> this.delegated.incrByFloat(key, integer));
    }

    public Long incr(byte[] key) {
        String command = "incr";
        return this.instrumented(command, () -> this.delegated.incr(key));
    }

    public Long append(byte[] key, byte[] value) {
        String command = "append";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.append(key, value));
    }

    public byte[] substr(byte[] key, int start, int end) {
        String command = "substr";
        return this.instrumented(command, () -> this.delegated.substr(key, start, end));
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        String command = "hset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hset(key, field, value));
    }

    public byte[] hget(byte[] key, byte[] field) {
        String command = "hget";
        return this.instrumented(command, () -> this.delegated.hget(key, field));
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        String command = "hsetnx";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.hsetnx(key, field, value));
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        String command = "hmset";
        return this.instrumented(command, () -> this.delegated.hmset(key, hash));
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        String command = "hmget";
        return this.instrumented(command, () -> this.delegated.hmget(key, fields));
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        String command = "hincrBy";
        return this.instrumented(command, () -> this.delegated.hincrBy(key, field, value));
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        String command = "hincrByFloat";
        return this.instrumented(command, () -> this.delegated.hincrByFloat(key, field, value));
    }

    public Boolean hexists(byte[] key, byte[] field) {
        String command = "hexists";
        return this.instrumented(command, () -> this.delegated.hexists(key, field));
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        String command = "hdel";
        return this.instrumented(command, () -> this.delegated.hdel(key, fields));
    }

    public Long hlen(byte[] key) {
        String command = "hlen";
        return this.instrumented(command, () -> this.delegated.hlen(key));
    }

    public Set<byte[]> hkeys(byte[] key) {
        String command = "hkeys";
        return this.instrumented(command, () -> this.delegated.hkeys(key));
    }

    public List<byte[]> hvals(byte[] key) {
        String command = "hvals";
        return this.instrumented(command, () -> this.delegated.hvals(key));
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        String command = "hgetAll";
        return this.instrumented(command, () -> this.delegated.hgetAll(key));
    }

    public Long rpush(byte[] key, byte[] ... strings) {
        String command = "rpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(strings), () -> this.delegated.rpush(key, strings));
    }

    public Long lpush(byte[] key, byte[] ... strings) {
        String command = "lpush";
        return this.instrumented(command, TelemetryHelper.payloadSize(strings), () -> this.delegated.lpush(key, strings));
    }

    public Long llen(byte[] key) {
        String command = "llen";
        return this.instrumented(command, () -> this.delegated.llen(key));
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        String command = "lrange";
        return this.instrumented(command, () -> this.delegated.lrange(key, start, end));
    }

    public String ltrim(byte[] key, long start, long end) {
        String command = "ltrim";
        return this.instrumented(command, () -> this.delegated.ltrim(key, start, end));
    }

    public byte[] lindex(byte[] key, long index) {
        String command = "lindex";
        return this.instrumented(command, () -> this.delegated.lindex(key, index));
    }

    public String lset(byte[] key, long index, byte[] value) {
        String command = "lset";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lset(key, index, value));
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        String command = "lrem";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.lrem(key, count, value));
    }

    public byte[] lpop(byte[] key) {
        String command = "lpop";
        return this.instrumented(command, () -> this.delegated.lpop(key));
    }

    public byte[] rpop(byte[] key) {
        String command = "rpop";
        return this.instrumented(command, () -> this.delegated.rpop(key));
    }

    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        String command = "rpoplpush";
        return this.instrumented(command, () -> this.delegated.rpoplpush(srckey, dstkey));
    }

    public Long sadd(byte[] key, byte[] ... members) {
        String command = "sadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(members), () -> this.delegated.sadd(key, members));
    }

    public Set<byte[]> smembers(byte[] key) {
        String command = "smembers";
        return this.instrumented(command, () -> this.delegated.smembers(key));
    }

    public Long srem(byte[] key, byte[] ... member) {
        String command = "srem";
        return this.instrumented(command, TelemetryHelper.payloadSize(member), () -> this.delegated.srem(key, member));
    }

    public byte[] spop(byte[] key) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key));
    }

    public Set<byte[]> spop(byte[] key, long count) {
        String command = "spop";
        return this.instrumented(command, () -> this.delegated.spop(key, count));
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        String command = "smove";
        return this.instrumented(command, () -> this.delegated.smove(srckey, dstkey, member));
    }

    public Long scard(byte[] key) {
        String command = "scard";
        return this.instrumented(command, () -> this.delegated.scard(key));
    }

    public Boolean sismember(byte[] key, byte[] member) {
        String command = "sismember";
        return this.instrumented(command, () -> this.delegated.sismember(key, member));
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        String command = "sinter";
        return this.instrumented(command, () -> this.delegated.sinter(keys));
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        String command = "sinterstore";
        return this.instrumented(command, () -> this.delegated.sinterstore(dstkey, keys));
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        String command = "sunion";
        return this.instrumented(command, () -> this.delegated.sunion(keys));
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        String command = "sunionstore";
        return this.instrumented(command, () -> this.delegated.sunionstore(dstkey, keys));
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        String command = "sdiff";
        return this.instrumented(command, () -> this.delegated.sdiff(keys));
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        String command = "sdiffstore";
        return this.instrumented(command, () -> this.delegated.sdiffstore(dstkey, keys));
    }

    public byte[] srandmember(byte[] key) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key));
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        String command = "srandmember";
        return this.instrumented(command, () -> this.delegated.srandmember(key, count));
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, score, member));
    }

    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, score, member, params));
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers));
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        String command = "zadd";
        return this.instrumented(command, () -> this.delegated.zadd(key, scoreMembers, params));
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        String command = "zrange";
        return this.instrumented(command, () -> this.delegated.zrange(key, start, end));
    }

    public Long zrem(byte[] key, byte[] ... members) {
        String command = "zrem";
        return this.instrumented(command, () -> this.delegated.zrem(key, members));
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member));
    }

    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        String command = "zincrby";
        return this.instrumented(command, () -> this.delegated.zincrby(key, score, member, params));
    }

    public Long zrank(byte[] key, byte[] member) {
        String command = "zrank";
        return this.instrumented(command, () -> this.delegated.zrank(key, member));
    }

    public Long zrevrank(byte[] key, byte[] member) {
        String command = "zrevrank";
        return this.instrumented(command, () -> this.delegated.zrevrank(key, member));
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        String command = "zrevrange";
        return this.instrumented(command, () -> this.delegated.zrevrange(key, start, end));
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        String command = "zrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeWithScores(key, start, end));
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        String command = "zrevrangeWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeWithScores(key, start, end));
    }

    public Long zcard(byte[] key) {
        String command = "zcard";
        return this.instrumented(command, () -> this.delegated.zcard(key));
    }

    public Double zscore(byte[] key, byte[] member) {
        String command = "zscore";
        return this.instrumented(command, () -> this.delegated.zscore(key, member));
    }

    public Transaction multi() {
        String command = "multi";
        return this.instrumented(command, () -> this.delegated.multi());
    }

    public void connect() {
        this.delegated.connect();
    }

    public void disconnect() {
        this.delegated.disconnect();
    }

    public void resetState() {
        this.delegated.resetState();
    }

    public String watch(byte[] ... keys) {
        String command = "watch";
        return this.instrumented(command, () -> this.delegated.watch(keys));
    }

    public String unwatch() {
        String command = "unwatch";
        return this.instrumented(command, () -> this.delegated.unwatch());
    }

    public List<byte[]> sort(byte[] key) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key));
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters));
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(timeout, keys));
    }

    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, sortingParameters, dstkey));
    }

    public Long sort(byte[] key, byte[] dstkey) {
        String command = "sort";
        return this.instrumented(command, () -> this.delegated.sort(key, dstkey));
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(timeout, keys));
    }

    public List<byte[]> blpop(byte[] ... args) {
        String command = "blpop";
        return this.instrumented(command, () -> this.delegated.blpop(args));
    }

    public List<byte[]> brpop(byte[] ... args) {
        String command = "brpop";
        return this.instrumented(command, () -> this.delegated.brpop(args));
    }

    public String auth(String password) {
        String command = "auth";
        return this.instrumented(command, () -> this.delegated.auth(password));
    }

    public Pipeline pipelined() {
        String command = "pipelined";
        return this.instrumented(command, () -> new InstrumentedPipeline(this.registry, this.delegated.pipelined(), this.poolName));
    }

    public Long zcount(byte[] key, double min, double max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        String command = "zcount";
        return this.instrumented(command, () -> this.delegated.zcount(key, min, max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max));
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        String command = "zrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrangeByScore(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        String command = "zrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrangeByScoreWithScores(key, min, max, offset, count));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        String command = "zrevrangeByScore";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScore(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        String command = "zrevrangeByScoreWithScores";
        return this.instrumented(command, () -> this.delegated.zrevrangeByScoreWithScores(key, max, min, offset, count));
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        String command = "zremrangeByRank";
        return this.instrumented(command, () -> this.delegated.zremrangeByRank(key, start, end));
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        String command = "zremrangeByScore";
        return this.instrumented(command, () -> this.delegated.zremrangeByScore(key, start, end));
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, sets));
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        String command = "zunionstore";
        return this.instrumented(command, () -> this.delegated.zunionstore(dstkey, params, sets));
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, sets));
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        String command = "zinterstore";
        return this.instrumented(command, () -> this.delegated.zinterstore(dstkey, params, sets));
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        String command = "zlexcount";
        return this.instrumented(command, () -> this.delegated.zlexcount(key, min, max));
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max));
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        String command = "zrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrangeByLex(key, min, max, offset, count));
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min));
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        String command = "zrevrangeByLex";
        return this.instrumented(command, () -> this.delegated.zrevrangeByLex(key, max, min, offset, count));
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        String command = "zremrangeByLex";
        return this.instrumented(command, () -> this.delegated.zremrangeByLex(key, min, max));
    }

    public String save() {
        String command = "save";
        return this.instrumented(command, () -> this.delegated.save());
    }

    public String bgsave() {
        String command = "bgsave";
        return this.instrumented(command, () -> this.delegated.bgsave());
    }

    public String bgrewriteaof() {
        String command = "bgrewriteaof";
        return this.instrumented(command, () -> this.delegated.bgrewriteaof());
    }

    public Long lastsave() {
        String command = "lastsave";
        return this.instrumented(command, () -> this.delegated.lastsave());
    }

    public String shutdown() {
        String command = "shutdown";
        return this.instrumented(command, () -> this.delegated.shutdown());
    }

    public String info() {
        String command = "info";
        return this.instrumented(command, () -> this.delegated.info());
    }

    public String info(String section) {
        String command = "info";
        return this.instrumented(command, () -> this.delegated.info(section));
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.delegated.monitor(jedisMonitor);
    }

    public String slaveof(String host, int port) {
        String command = "slaveof";
        return this.instrumented(command, () -> this.delegated.slaveof(host, port));
    }

    public String slaveofNoOne() {
        String command = "slaveofNoOne";
        return this.instrumented(command, () -> this.delegated.slaveofNoOne());
    }

    public List<byte[]> configGet(byte[] pattern) {
        String command = "configGet";
        return this.instrumented(command, () -> this.delegated.configGet(pattern));
    }

    public String configResetStat() {
        String command = "configResetStat";
        return this.instrumented(command, () -> this.delegated.configResetStat());
    }

    public byte[] configSet(byte[] parameter, byte[] value) {
        String command = "configSet";
        return this.instrumented(command, () -> this.delegated.configSet(parameter, value));
    }

    public boolean isConnected() {
        String command = "isConnected";
        return this.instrumented(command, () -> this.delegated.isConnected());
    }

    public Long strlen(byte[] key) {
        String command = "strlen";
        return this.instrumented(command, () -> this.delegated.strlen(key));
    }

    public void sync() {
        this.delegated.sync();
    }

    public Long lpushx(byte[] key, byte[] ... string) {
        String command = "lpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.lpushx(key, string));
    }

    public Long persist(byte[] key) {
        String command = "persist";
        return this.instrumented(command, () -> this.delegated.persist(key));
    }

    public Long rpushx(byte[] key, byte[] ... string) {
        String command = "rpushx";
        return this.instrumented(command, TelemetryHelper.payloadSize(string), () -> this.delegated.rpushx(key, string));
    }

    public byte[] echo(byte[] string) {
        String command = "echo";
        return this.instrumented(command, () -> this.delegated.echo(string));
    }

    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        String command = "linsert";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.linsert(key, where, pivot, value));
    }

    public String debug(DebugParams params) {
        String command = "debug";
        return this.instrumented(command, () -> this.delegated.debug(params));
    }

    public Client getClient() {
        String command = "getClient";
        return this.instrumented(command, () -> this.delegated.getClient());
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        String command = "brpoplpush";
        return this.instrumented(command, () -> this.delegated.brpoplpush(source, destination, timeout));
    }

    public Boolean setbit(byte[] key, long offset, boolean value) {
        String command = "setbit";
        return this.instrumented(command, () -> this.delegated.setbit(key, offset, value));
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        String command = "setbit";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setbit(key, offset, value));
    }

    public Boolean getbit(byte[] key, long offset) {
        String command = "getbit";
        return this.instrumented(command, () -> this.delegated.getbit(key, offset));
    }

    public Long bitpos(byte[] key, boolean value) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value));
    }

    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        String command = "bitpos";
        return this.instrumented(command, () -> this.delegated.bitpos(key, value, params));
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        String command = "setrange";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.setrange(key, offset, value));
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        String command = "getrange";
        return this.instrumented(command, () -> this.delegated.getrange(key, startOffset, endOffset));
    }

    public Long publish(byte[] channel, byte[] message) {
        String command = "publish";
        return this.instrumented(command, TelemetryHelper.payloadSize(message), () -> this.delegated.publish(channel, message));
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.delegated.subscribe(jedisPubSub, channels);
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.delegated.psubscribe(jedisPubSub, patterns);
    }

    public int getDB() {
        String command = "getDB";
        return this.instrumented(command, () -> this.delegated.getDB());
    }

    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(args), () -> this.delegated.eval(script, keys, args));
    }

    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(params), () -> this.delegated.eval(script, keyCount, params));
    }

    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script) + TelemetryHelper.payloadSize(params), () -> this.delegated.eval(script, keyCount, params));
    }

    public Object eval(byte[] script) {
        String command = "eval";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.eval(script));
    }

    public Object evalsha(byte[] sha1) {
        String command = "evalsha";
        return this.instrumented(command, () -> this.delegated.evalsha(sha1));
    }

    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(args), () -> this.delegated.evalsha(sha1, keys, args));
    }

    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        String command = "evalsha";
        return this.instrumented(command, TelemetryHelper.payloadSize(params), () -> this.delegated.evalsha(sha1, keyCount, params));
    }

    public String scriptFlush() {
        String command = "scriptFlush";
        return this.instrumented(command, () -> this.delegated.scriptFlush());
    }

    public Long scriptExists(byte[] sha1) {
        String command = "scriptExists";
        return this.instrumented(command, () -> this.delegated.scriptExists(sha1));
    }

    public List<Long> scriptExists(byte[] ... sha1) {
        String command = "scriptExists";
        return this.instrumented(command, () -> this.delegated.scriptExists(sha1));
    }

    public byte[] scriptLoad(byte[] script) {
        String command = "scriptLoad";
        return this.instrumented(command, TelemetryHelper.payloadSize(script), () -> this.delegated.scriptLoad(script));
    }

    public String scriptKill() {
        String command = "scriptKill";
        return this.instrumented(command, () -> this.delegated.scriptKill());
    }

    public String slowlogReset() {
        String command = "slowlogReset";
        return this.instrumented(command, () -> this.delegated.slowlogReset());
    }

    public Long slowlogLen() {
        String command = "slowlogLen";
        return this.instrumented(command, () -> this.delegated.slowlogLen());
    }

    public List<Object> slowlogGetBinary() {
        String command = "slowlogGetBinary";
        return this.instrumented(command, () -> this.delegated.slowlogGetBinary());
    }

    public List<Object> slowlogGetBinary(long entries) {
        String command = "slowlogGetBinary";
        return this.instrumented(command, () -> this.delegated.slowlogGetBinary(entries));
    }

    public Long objectRefcount(byte[] key) {
        String command = "objectRefcount";
        return this.instrumented(command, () -> this.delegated.objectRefcount(key));
    }

    public byte[] objectEncoding(byte[] key) {
        String command = "objectEncoding";
        return this.instrumented(command, () -> this.delegated.objectEncoding(key));
    }

    public Long objectIdletime(byte[] key) {
        String command = "objectIdletime";
        return this.instrumented(command, () -> this.delegated.objectIdletime(key));
    }

    public Long bitcount(byte[] key) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key));
    }

    public Long bitcount(byte[] key, long start, long end) {
        String command = "bitcount";
        return this.instrumented(command, () -> this.delegated.bitcount(key, start, end));
    }

    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        String command = "bitop";
        return this.instrumented(command, () -> this.delegated.bitop(op, destKey, srcKeys));
    }

    public byte[] dump(byte[] key) {
        String command = "dump";
        return this.instrumented(command, () -> this.delegated.dump(key));
    }

    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        String command = "restore";
        return this.instrumented(command, () -> this.delegated.restore(key, ttl, serializedValue));
    }

    public Long pexpire(byte[] key, long milliseconds) {
        String command = "pexpire";
        return this.instrumented(command, () -> this.delegated.pexpire(key, milliseconds));
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        String command = "pexpireAt";
        return this.instrumented(command, () -> this.delegated.pexpireAt(key, millisecondsTimestamp));
    }

    public Long pttl(byte[] key) {
        String command = "pttl";
        return this.instrumented(command, () -> this.delegated.pttl(key));
    }

    public String psetex(byte[] key, long milliseconds, byte[] value) {
        String command = "psetex";
        return this.instrumented(command, TelemetryHelper.payloadSize(value), () -> this.delegated.psetex(key, milliseconds, value));
    }

    public String clientKill(byte[] client) {
        String command = "clientKill";
        return this.instrumented(command, () -> this.delegated.clientKill(client));
    }

    public String clientGetname() {
        String command = "clientGetname";
        return this.instrumented(command, () -> this.delegated.clientGetname());
    }

    public String clientList() {
        String command = "clientList";
        return this.instrumented(command, () -> this.delegated.clientList());
    }

    public String clientSetname(byte[] name) {
        String command = "clientSetname";
        return this.instrumented(command, () -> this.delegated.clientSetname(name));
    }

    public List<String> time() {
        String command = "time";
        return this.instrumented(command, () -> this.delegated.time());
    }

    public Long waitReplicas(int replicas, long timeout) {
        String command = "waitReplicas";
        return this.instrumented(command, () -> this.delegated.waitReplicas(replicas, timeout));
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        String command = "pfadd";
        return this.instrumented(command, TelemetryHelper.payloadSize(elements), () -> this.delegated.pfadd(key, elements));
    }

    public long pfcount(byte[] key) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(key));
    }

    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        String command = "pfmerge";
        return this.instrumented(command, () -> this.delegated.pfmerge(destkey, sourcekeys));
    }

    public Long pfcount(byte[] ... keys) {
        String command = "pfcount";
        return this.instrumented(command, () -> this.delegated.pfcount(keys));
    }

    public ScanResult<byte[]> scan(byte[] cursor) {
        String command = "scan";
        return this.instrumented(command, () -> this.delegated.scan(cursor));
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        String command = "scan";
        return this.instrumented(command, () -> this.delegated.scan(cursor, params));
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        String command = "hscan";
        return this.instrumented(command, () -> this.delegated.hscan(key, cursor));
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        String command = "hscan";
        return this.instrumented(command, () -> this.delegated.hscan(key, cursor, params));
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        String command = "sscan";
        return this.instrumented(command, () -> this.delegated.sscan(key, cursor));
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        String command = "sscan";
        return this.instrumented(command, () -> this.delegated.sscan(key, cursor, params));
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        String command = "zscan";
        return this.instrumented(command, () -> this.delegated.zscan(key, cursor));
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        String command = "zscan";
        return this.instrumented(command, () -> this.delegated.zscan(key, cursor, params));
    }

    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, longitude, latitude, member));
    }

    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        String command = "geoadd";
        return this.instrumented(command, () -> this.delegated.geoadd(key, memberCoordinateMap));
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2));
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        String command = "geodist";
        return this.instrumented(command, () -> this.delegated.geodist(key, member1, member2, unit));
    }

    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        String command = "geohash";
        return this.instrumented(command, () -> this.delegated.geohash(key, members));
    }

    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        String command = "geopos";
        return this.instrumented(command, () -> this.delegated.geopos(key, members));
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit));
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadius";
        return this.instrumented(command, () -> this.delegated.georadius(key, longitude, latitude, radius, unit, param));
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit));
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        String command = "georadiusByMember";
        return this.instrumented(command, () -> this.delegated.georadiusByMember(key, member, radius, unit, param));
    }

    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        String command = "bitfield";
        return this.instrumented(command, () -> this.delegated.bitfield(key, arguments));
    }
}

