/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis.telemetry;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryHelper {
    private static final String DEFAULT_ID_PREFIX = "redis.command";
    private static final String POOL_TAG = "poolName";
    private static Logger log = LoggerFactory.getLogger(TelemetryHelper.class);

    static Id timerId(Registry registry, String name, String command, boolean pipelined) {
        return registry.createId("redis.command.latency." + command).withTags(POOL_TAG, name, "pipelined", String.valueOf(pipelined));
    }

    static Id payloadSizeId(Registry registry, String name, String command, boolean pipelined) {
        return registry.createId("redis.command.payloadSize." + command).withTags(POOL_TAG, name, "pipelined", String.valueOf(pipelined));
    }

    static Id invocationId(Registry registry, String name, String command, boolean pipelined, boolean success) {
        return registry.createId("redis.command.invocation." + command).withTags(POOL_TAG, name, "pipelined", String.valueOf(pipelined), "success", String.valueOf(success));
    }

    static long payloadSize(String payload) {
        try {
            return payload.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            log.error("could not get payload size, setting to -1", (Throwable)e);
            return -1L;
        }
    }

    static long payloadSize(String ... payload) {
        long size = 0L;
        for (String p : payload) {
            size += TelemetryHelper.payloadSize(p);
        }
        return size;
    }

    static long payloadSize(Map<String, String> payload) {
        long size = 0L;
        for (Map.Entry<String, String> e : payload.entrySet()) {
            size += TelemetryHelper.payloadSize(e.getKey());
            size += TelemetryHelper.payloadSize(e.getValue());
        }
        return size;
    }

    static long payloadSize(byte[] payload) {
        return payload.length;
    }

    static long payloadSize(byte[] ... payload) {
        long size = 0L;
        for (byte[] p : payload) {
            size += (long)p.length;
        }
        return size;
    }

    static long payloadSize(List payload) {
        long size = 0L;
        for (Object p : payload) {
            if (p instanceof String) {
                size += TelemetryHelper.payloadSize((String)p);
                continue;
            }
            size += TelemetryHelper.payloadSize((byte[])p);
        }
        return size;
    }
}

