/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.netflix.spinnaker.kork.jedis.JedisClientDelegate;
import java.lang.reflect.Field;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.Pool;

public class JedisHealthIndicatorFactory {
    public static HealthIndicator build(JedisClientDelegate client) {
        try {
            JedisClientDelegate src = client;
            Field clientAccess = JedisClientDelegate.class.getDeclaredField("jedisPool");
            clientAccess.setAccessible(true);
            return JedisHealthIndicatorFactory.build((Pool<Jedis>)((Pool)clientAccess.get(src)));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new BeanCreationException("Error creating Redis health indicator", (Throwable)e);
        }
    }

    public static HealthIndicator build(Pool<Jedis> jedisPool) {
        try {
            Pool<Jedis> src = jedisPool;
            Field poolAccess = Pool.class.getDeclaredField("internalPool");
            poolAccess.setAccessible(true);
            GenericObjectPool internal = (GenericObjectPool)poolAccess.get(jedisPool);
            return () -> {
                Health.Builder health;
                try (Jedis jedis = null;){
                    jedis = (Jedis)src.getResource();
                    health = "PONG".equals(jedis.ping()) ? Health.up() : Health.down();
                }
                health.withDetail("maxIdle", (Object)internal.getMaxIdle());
                health.withDetail("minIdle", (Object)internal.getMinIdle());
                health.withDetail("numActive", (Object)internal.getNumActive());
                health.withDetail("numIdle", (Object)internal.getNumIdle());
                health.withDetail("numWaiters", (Object)internal.getNumWaiters());
                return health.build();
            };
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new BeanCreationException("Error creating Redis health indicator", (Throwable)e);
        }
    }
}

