/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.jedis.JedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.JedisDriverProperties;
import com.netflix.spinnaker.kork.jedis.JedisPoolFactory;
import com.netflix.spinnaker.kork.jedis.RedisClientConfiguration;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegateFactory;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class JedisClientDelegateFactory
implements RedisClientDelegateFactory<JedisClientDelegate> {
    private Registry registry;
    private ObjectMapper objectMapper;
    private GenericObjectPoolConfig objectPoolConfig;

    public JedisClientDelegateFactory(Registry registry, ObjectMapper objectMapper, GenericObjectPoolConfig objectPoolConfig) {
        this.registry = registry;
        this.objectMapper = objectMapper;
        this.objectPoolConfig = objectPoolConfig;
    }

    @Override
    public boolean supports(RedisClientConfiguration.Driver driver) {
        return driver == RedisClientConfiguration.Driver.REDIS;
    }

    @Override
    public JedisClientDelegate build(String name, Map<String, Object> properties) {
        JedisDriverProperties props = (JedisDriverProperties)this.objectMapper.convertValue(properties, JedisDriverProperties.class);
        return new JedisClientDelegate(name, new JedisPoolFactory(this.registry).build(name, props, this.objectPoolConfig));
    }
}

