/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import java.net.URI;

public class RedisClientConnectionProperties {
    private URI connection;

    public RedisClientConnectionProperties(URI connection) {
        this.connection = connection;
    }

    public boolean isSSL() {
        return this.connection.getScheme().equals("rediss");
    }

    public String password() {
        if (this.connection.getUserInfo() == null || !this.connection.getUserInfo().contains(":")) {
            return null;
        }
        return this.connection.getUserInfo().split(":", 2)[1];
    }

    public String addr() {
        return this.connection.getHost();
    }

    public int port() {
        return this.connection.getPort() == -1 ? 6379 : this.connection.getPort();
    }

    public int database() {
        if (this.connection.getPath() == null || this.connection.getPath().equals("") || this.connection.getPath().equals("/")) {
            return 0;
        }
        return Integer.parseInt(this.connection.getPath().substring(1));
    }
}

