/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.jedis.JedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.JedisClientDelegateFactory;
import com.netflix.spinnaker.kork.jedis.JedisHealthIndicatorFactory;
import com.netflix.spinnaker.kork.jedis.RedisClientConfiguration;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={RedisClientConfiguration.class})
public class JedisClientConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={GenericObjectPoolConfig.class})
    @ConfigurationProperties(value="redis")
    public GenericObjectPoolConfig redisPoolConfig() {
        return new GenericObjectPoolConfig();
    }

    @Bean
    @ConditionalOnProperty(value={"redis.cluster-enabled"}, havingValue="false", matchIfMissing=true)
    public JedisClientDelegateFactory jedisClientDelegateFactory(Registry registry, ObjectMapper objectMapper, GenericObjectPoolConfig redisPoolConfig) {
        return new JedisClientDelegateFactory(registry, objectMapper, redisPoolConfig);
    }

    @Bean
    @ConditionalOnProperty(value={"redis.cluster-enabled"}, havingValue="false", matchIfMissing=true)
    public List<HealthIndicator> jedisClientHealthIndicators(List<RedisClientDelegate> redisClientDelegates) {
        return redisClientDelegates.stream().filter(it -> it instanceof JedisClientDelegate).map(it -> JedisHealthIndicatorFactory.build((JedisClientDelegate)it)).collect(Collectors.toList());
    }
}

