/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.jedis;

import com.netflix.spinnaker.kork.jedis.RedisClientConnectionProperties;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegateFactory;
import com.netflix.spinnaker.kork.jedis.RedisClientSelector;
import com.netflix.spinnaker.kork.jedis.exception.RedisClientFactoryNotFound;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

@Configuration
@EnableConfigurationProperties(value={ClientConfigurationWrapper.class, RedisDriverConfiguration.class, DualClientConfiguration.class})
public class RedisClientConfiguration {
    private final List<RedisClientDelegateFactory> clientDelegateFactories;

    @Autowired
    RedisClientConfiguration(Optional<List<RedisClientDelegateFactory>> clientDelegateFactories) {
        this.clientDelegateFactories = clientDelegateFactories.orElse(Collections.emptyList());
    }

    @ConditionalOnProperty(value={"redis.cluster-enabled"}, havingValue="false", matchIfMissing=true)
    @Bean(value={"namedRedisClients"})
    public List<RedisClientDelegate> redisClientDelegates(ClientConfigurationWrapper redisClientConfigurations, Optional<List<RedisClientDelegate>> otherRedisClientDelegates) {
        ArrayList<RedisClientDelegate> clients = new ArrayList<RedisClientDelegate>();
        redisClientConfigurations.clients.forEach((name, config) -> {
            if (config.primary != null) {
                clients.add((RedisClientDelegate)this.getClientFactoryForDriver(config.primary.driver).build(RedisClientSelector.getName(true, name), config.primary.config));
            }
            if (config.previous != null) {
                clients.add((RedisClientDelegate)this.getClientFactoryForDriver(config.previous.driver).build(RedisClientSelector.getName(false, name), config.previous.config));
            }
        });
        otherRedisClientDelegates.ifPresent(clients::addAll);
        this.createDefaultClientIfNotExists(clients, ConnectionCompatibility.PRIMARY, redisClientConfigurations);
        this.createDefaultClientIfNotExists(clients, ConnectionCompatibility.PREVIOUS, redisClientConfigurations);
        return clients;
    }

    private void createDefaultClientIfNotExists(List<RedisClientDelegate> clients, ConnectionCompatibility connection, ClientConfigurationWrapper rootConfig) {
        String name = connection == ConnectionCompatibility.PRIMARY ? "primaryDefault" : "previousDefault";
        if (clients.stream().noneMatch(c -> name.equals(c.name()))) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (connection == ConnectionCompatibility.PRIMARY) {
                Optional.ofNullable(rootConfig.connection).map(v -> {
                    if (!Optional.ofNullable(properties.get("connection")).isPresent()) {
                        properties.put("connection", v);
                    }
                    return v;
                });
            } else {
                Optional.ofNullable(rootConfig.connectionPrevious).map(v -> {
                    if (!Optional.ofNullable(properties.get("connection")).isPresent()) {
                        properties.put("connection", v);
                    }
                    return v;
                });
            }
            Optional.ofNullable(rootConfig.timeoutMs).map(v -> {
                if (!Optional.ofNullable(properties.get("timeoutMs")).isPresent()) {
                    properties.put("timeoutMs", v);
                }
                return v;
            });
            if (this.stringIsNullOrEmpty((String)properties.get("connection"))) {
                return;
            }
            clients.add((RedisClientDelegate)this.getClientFactoryForDriver(Driver.REDIS).build(name, properties));
        }
    }

    private boolean stringIsNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    @Bean
    @ConditionalOnProperty(value={"redis.cluster-enabled"}, havingValue="false", matchIfMissing=true)
    public RedisClientSelector redisClientSelector(@Qualifier(value="namedRedisClients") List<RedisClientDelegate> redisClientDelegates) {
        return new RedisClientSelector(redisClientDelegates);
    }

    private RedisClientDelegateFactory<?> getClientFactoryForDriver(Driver driver) {
        return this.clientDelegateFactories.stream().filter(it -> it.supports(driver)).findFirst().orElseThrow(() -> new RedisClientFactoryNotFound("Could not find factory for driver: " + driver.name()));
    }

    @Bean(value={"jedisCluster"})
    @ConditionalOnProperty(value={"redis.cluster-enabled"})
    @Primary
    public JedisCluster jedisCluster(GenericObjectPoolConfig objectPoolConfig, ClientConfigurationWrapper config) {
        URI cx = URI.create(config.connection);
        return this.getJedisCluster(objectPoolConfig, config, cx);
    }

    @Bean(value={"previousJedisCluster"})
    @ConditionalOnProperty(value={"redis.previous-cluster-enabled"})
    public JedisCluster previousJedisCluster(GenericObjectPoolConfig objectPoolConfig, ClientConfigurationWrapper config) {
        URI cx = URI.create(config.connectionPrevious);
        return this.getJedisCluster(objectPoolConfig, config, cx);
    }

    private JedisCluster getJedisCluster(GenericObjectPoolConfig objectPoolConfig, ClientConfigurationWrapper config, URI cx) {
        RedisClientConnectionProperties cxp = new RedisClientConnectionProperties(cx);
        return new JedisCluster(new HostAndPort(cxp.addr(), cxp.port()), config.getTimeoutMs().intValue(), config.getTimeoutMs().intValue(), config.getMaxAttempts().intValue(), cxp.password(), null, objectPoolConfig, cxp.isSSL());
    }

    @ConfigurationProperties(prefix="redis")
    public static class ClientConfigurationWrapper {
        Map<String, DualClientConfiguration> clients = new HashMap<String, DualClientConfiguration>();
        String connection;
        String connectionPrevious;
        Integer timeoutMs = 2000;
        Integer maxAttempts = 5;
        Boolean clusterEnabled;
        Boolean previousClusterEnabled;

        public Map<String, DualClientConfiguration> getClients() {
            return this.clients;
        }

        public void setClients(Map<String, DualClientConfiguration> clients) {
            this.clients = clients;
        }

        public String getConnection() {
            return this.connection;
        }

        public void setConnection(String connection) {
            this.connection = connection;
        }

        public String getConnectionPrevious() {
            return this.connectionPrevious;
        }

        public void setConnectionPrevious(String connectionPrevious) {
            this.connectionPrevious = connectionPrevious;
        }

        public Integer getTimeoutMs() {
            return this.timeoutMs;
        }

        public void setTimeoutMs(Integer timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public Boolean getClusterEnabled() {
            return this.clusterEnabled;
        }

        public void setClusterEnabled(Boolean clusterEnabled) {
            this.clusterEnabled = clusterEnabled;
        }

        public Boolean getPreviousClusterEnabled() {
            return this.previousClusterEnabled;
        }

        public void setPreviousClusterEnabled(Boolean previousClusterEnabled) {
            this.previousClusterEnabled = previousClusterEnabled;
        }
    }

    private static enum ConnectionCompatibility {
        PRIMARY("connection"),
        PREVIOUS("connectionPrevious");

        private final String value;

        private ConnectionCompatibility(String value) {
            this.value = value;
        }
    }

    public static enum Driver {
        REDIS("redis"),
        DYNOMITE("dynomite");

        private final String value;

        private Driver(String value) {
            this.value = value;
        }
    }

    @ConfigurationProperties
    public static class DualClientConfiguration {
        public RedisDriverConfiguration primary;
        public RedisDriverConfiguration previous;

        public RedisDriverConfiguration getPrimary() {
            return this.primary;
        }

        public void setPrimary(RedisDriverConfiguration primary) {
            this.primary = primary;
        }

        public RedisDriverConfiguration getPrevious() {
            return this.previous;
        }

        public void setPrevious(RedisDriverConfiguration previous) {
            this.previous = previous;
        }
    }

    @ConfigurationProperties
    public static class RedisDriverConfiguration {
        public Driver driver = Driver.REDIS;
        public Map<String, Object> config = new HashMap<String, Object>();

        public Driver getDriver() {
            return this.driver;
        }

        public void setDriver(Driver driver) {
            this.driver = driver;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, Object> config) {
            this.config = config;
        }
    }
}

