/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.testplugin;

import com.netflix.spinnaker.kork.plugins.testplugin.GeneratedTestPlugin;
import com.netflix.spinnaker.kork.plugins.testplugin.SourceFile;
import com.netflix.spinnaker.kork.plugins.testplugin.TestPluginGenerator;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bH\u0002J\b\u0010\u001c\u001a\u00020\fH\u0002J\f\u0010\u001d\u001a\u00020\f*\u00020\u0010H\u0002J\f\u0010\u001e\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginGenerator;", "", "testPlugin", "Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin;", "rootPath", "Ljava/nio/file/Path;", "(Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin;Ljava/nio/file/Path;)V", "pluginPath", "getPluginPath", "()Ljava/nio/file/Path;", "getRootPath", "generate", "", "generateSources", "Lkotlin/Pair;", "", "Ljava/io/File;", "preparePluginDestination", "setupCompiler", "Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginGenerator$CompilerSetup;", "classesDir", "generated", "substituteVariables", "", "simpleName", "body", "systemClasspath", "", "writePluginProperties", "recursiveDeleteOnExit", "recursivelyDeleteOnExit", "CompilerSetup", "kork-plugins-tck"})
public final class TestPluginGenerator {
    @NotNull
    private final Path pluginPath;
    private final GeneratedTestPlugin testPlugin;
    @NotNull
    private final Path rootPath;

    @NotNull
    public final Path getPluginPath() {
        return this.pluginPath;
    }

    public final void generate() {
        Pair<Path, File[]> generated = this.generateSources();
        File classesDir = this.preparePluginDestination();
        this.writePluginProperties();
        CompilerSetup compilerSetup = this.setupCompiler(classesDir, generated);
        if (!compilerSetup.getTask().call().booleanValue()) {
            List<Diagnostic<JavaFileObject>> list = compilerSetup.getDiagnostics().getDiagnostics();
            Intrinsics.checkNotNullExpressionValue(list, (String)"compilerSetup.diagnostics.diagnostics");
            Iterable iterable = list;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.lineSeparator()");
            String message2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)generate.message.1.INSTANCE, (int)30, null);
            throw (Throwable)new IllegalStateException("generation failed: " + System.lineSeparator() + message2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Path, File[]> generateSources() {
        Collection<File> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path path = Files.createTempDirectory("plugincodegen", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempDirectory(\"plugincodegen\")");
        Path tempDir = this.recursivelyDeleteOnExit(path);
        Path packageDir = tempDir.resolve(StringsKt.replace$default((String)this.testPlugin.getPackageName(), (char)'.', (char)'/', (boolean)false, (int)4, null));
        packageDir.toFile().mkdirs();
        Iterable iterable = this.testPlugin.sourceFiles();
        Path path2 = tempDir;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void source;
            SourceFile sourceFile = (SourceFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            File file = packageDir.resolve(source.getSimpleName() + ".java").toFile();
            boolean bl2 = false;
            boolean bl3 = false;
            File it = file;
            boolean bl4 = false;
            File file2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
            FilesKt.writeText$default((File)file2, (String)this.substituteVariables(source.getSimpleName(), source.getContents()), null, (int)2, null);
            File file3 = file;
            collection.add(file3);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        if (fileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        File[] fileArray2 = fileArray;
        Path path3 = path2;
        return new Pair((Object)path3, (Object)fileArray2);
    }

    /*
     * WARNING - void declaration
     */
    private final String substituteVariables(String simpleName, String body) {
        void $this$forEach$iv;
        String result = body;
        Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"pluginName", (Object)this.testPlugin.getName()), TuplesKt.to((Object)"simpleName", (Object)simpleName), TuplesKt.to((Object)"basePackageName", (Object)this.testPlugin.getPackageName())});
        boolean $i$f$forEach = false;
        void var6_6 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void t;
            Map.Entry element$iv;
            Map.Entry $dstr$t$u = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$t$u;
            boolean bl3 = false;
            String string = (String)entry.getKey();
            entry = $dstr$t$u;
            bl3 = false;
            String u = (String)entry.getValue();
            result = StringsKt.replace$default((String)result, (String)("{{" + (String)t + "}}"), (String)u, (boolean)false, (int)4, null);
        }
        return result;
    }

    private final File preparePluginDestination() {
        File file = this.pluginPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"pluginPath.toFile()");
        FilesKt.deleteRecursively((File)file);
        File classOutput = this.pluginPath.resolve("classes").toFile();
        classOutput.mkdirs();
        File file2 = classOutput;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"classOutput");
        return file2;
    }

    private final void writePluginProperties() {
        File file = this.pluginPath.resolve("plugin.properties").toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"pluginPath.resolve(\"plugin.properties\").toFile()");
        FilesKt.writeText$default((File)file, (String)this.testPlugin.properties(), null, (int)2, null);
    }

    private final CompilerSetup setupCompiler(File classesDir, Pair<? extends Path, File[]> generated) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector<JavaFileObject> diag = new DiagnosticCollector<JavaFileObject>();
        StandardJavaFileManager sfm = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diag, null, Charsets.UTF_8);
        sfm.setLocation(StandardLocation.CLASS_OUTPUT, CollectionsKt.listOf((Object)classesDir));
        sfm.setLocation(StandardLocation.SOURCE_PATH, CollectionsKt.listOf((Object)((Path)generated.getFirst()).toFile()));
        sfm.setLocation(StandardLocation.CLASS_PATH, this.systemClasspath());
        File[] fileArray = (File[])generated.getSecond();
        Iterable<? extends JavaFileObject> javaFiles = sfm.getJavaFileObjects(Arrays.copyOf(fileArray, fileArray.length));
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, sfm, (DiagnosticListener<? super JavaFileObject>)diag, null, null, javaFiles);
        Intrinsics.checkNotNullExpressionValue((Object)compilationTask, (String)"compiler.getTask(null, s\u2026g, null, null, javaFiles)");
        return new CompilerSetup(compilationTask, diag);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<File> systemClasspath() {
        void $this$mapTo$iv$iv;
        String string = System.getProperty("java.class.path");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.getProperty(\"java.class.path\")");
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        String string2 = System.getProperty("path.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"path.separator\")");
        stringArray[0] = string2;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)it);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    private final Path recursivelyDeleteOnExit(Path $this$recursivelyDeleteOnExit) {
        Path path = $this$recursivelyDeleteOnExit;
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        File file = $this$recursivelyDeleteOnExit.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
        this.recursiveDeleteOnExit(file);
        return path;
    }

    private final void recursiveDeleteOnExit(File $this$recursiveDeleteOnExit) {
        $this$recursiveDeleteOnExit.deleteOnExit();
        File[] fileArray = $this$recursiveDeleteOnExit.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                if (file.isDirectory()) {
                    this.recursiveDeleteOnExit(it);
                    continue;
                }
                it.deleteOnExit();
            }
        }
    }

    @NotNull
    public final Path getRootPath() {
        return this.rootPath;
    }

    public TestPluginGenerator(@NotNull GeneratedTestPlugin testPlugin, @NotNull Path rootPath) {
        Intrinsics.checkNotNullParameter((Object)testPlugin, (String)"testPlugin");
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.testPlugin = testPlugin;
        this.rootPath = rootPath;
        Path path = Files.createTempDirectory(this.rootPath, this.testPlugin.getName(), new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempDirector\u2026ootPath, testPlugin.name)");
        this.pluginPath = this.recursivelyDeleteOnExit(path);
        this.recursivelyDeleteOnExit(this.rootPath);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/TestPluginGenerator$CompilerSetup;", "", "task", "Ljavax/tools/JavaCompiler$CompilationTask;", "diagnostics", "Ljavax/tools/DiagnosticCollector;", "Ljavax/tools/JavaFileObject;", "(Ljavax/tools/JavaCompiler$CompilationTask;Ljavax/tools/DiagnosticCollector;)V", "getDiagnostics", "()Ljavax/tools/DiagnosticCollector;", "getTask", "()Ljavax/tools/JavaCompiler$CompilationTask;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kork-plugins-tck"})
    private static final class CompilerSetup {
        @NotNull
        private final JavaCompiler.CompilationTask task;
        @NotNull
        private final DiagnosticCollector<JavaFileObject> diagnostics;

        @NotNull
        public final JavaCompiler.CompilationTask getTask() {
            return this.task;
        }

        @NotNull
        public final DiagnosticCollector<JavaFileObject> getDiagnostics() {
            return this.diagnostics;
        }

        public CompilerSetup(@NotNull JavaCompiler.CompilationTask task, @NotNull DiagnosticCollector<JavaFileObject> diagnostics) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            this.task = task;
            this.diagnostics = diagnostics;
        }

        @NotNull
        public final JavaCompiler.CompilationTask component1() {
            return this.task;
        }

        @NotNull
        public final DiagnosticCollector<JavaFileObject> component2() {
            return this.diagnostics;
        }

        @NotNull
        public final CompilerSetup copy(@NotNull JavaCompiler.CompilationTask task, @NotNull DiagnosticCollector<JavaFileObject> diagnostics) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            return new CompilerSetup(task, diagnostics);
        }

        public static /* synthetic */ CompilerSetup copy$default(CompilerSetup compilerSetup, JavaCompiler.CompilationTask compilationTask, DiagnosticCollector diagnosticCollector, int n, Object object) {
            if ((n & 1) != 0) {
                compilationTask = compilerSetup.task;
            }
            if ((n & 2) != 0) {
                diagnosticCollector = compilerSetup.diagnostics;
            }
            return compilerSetup.copy(compilationTask, diagnosticCollector);
        }

        @NotNull
        public String toString() {
            return "CompilerSetup(task=" + this.task + ", diagnostics=" + this.diagnostics + ")";
        }

        public int hashCode() {
            JavaCompiler.CompilationTask compilationTask = this.task;
            DiagnosticCollector<JavaFileObject> diagnosticCollector = this.diagnostics;
            return (compilationTask != null ? compilationTask.hashCode() : 0) * 31 + (diagnosticCollector != null ? diagnosticCollector.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompilerSetup)) break block3;
                    CompilerSetup compilerSetup = (CompilerSetup)object;
                    if (!Intrinsics.areEqual((Object)this.task, (Object)compilerSetup.task) || !Intrinsics.areEqual(this.diagnostics, compilerSetup.diagnostics)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

