/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.internal;

import com.netflix.spinnaker.kork.plugins.internal.ClassDataProvider;
import com.netflix.spinnaker.kork.plugins.internal.DefaultClassDataProvider;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/netflix/spinnaker/kork/plugins/internal/PluginJar;", "", "builder", "Lcom/netflix/spinnaker/kork/plugins/internal/PluginJar$Builder;", "(Lcom/netflix/spinnaker/kork/plugins/internal/PluginJar$Builder;)V", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "pluginClass", "", "getPluginClass", "()Ljava/lang/String;", "pluginId", "getPluginId", "pluginVersion", "getPluginVersion", "Builder", "Companion", "kork-plugins-tck"})
public final class PluginJar {
    @NotNull
    private final Path path;
    @NotNull
    private final String pluginId;
    @NotNull
    private final String pluginClass;
    @NotNull
    private final String pluginVersion;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public final String getPluginClass() {
        return this.pluginClass;
    }

    @NotNull
    public final String getPluginVersion() {
        return this.pluginVersion;
    }

    private PluginJar(Builder builder) {
        this.path = builder.getPath();
        this.pluginId = builder.getPluginId();
        this.pluginClass = builder.getPluginClass();
        this.pluginVersion = builder.getPluginVersion();
    }

    public /* synthetic */ PluginJar(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005J\u0014\u0010\t\u001a\u00020\u00002\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\b\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J\u001a\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050$J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013\u00a8\u0006%"}, d2={"Lcom/netflix/spinnaker/kork/plugins/internal/PluginJar$Builder;", "", "path", "Ljava/nio/file/Path;", "pluginId", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "classDataProvider", "Lcom/netflix/spinnaker/kork/plugins/internal/ClassDataProvider;", "extensions", "", "manifestAttributes", "", "getPath", "()Ljava/nio/file/Path;", "pluginClass", "getPluginClass", "()Ljava/lang/String;", "setPluginClass", "(Ljava/lang/String;)V", "getPluginId", "pluginVersion", "getPluginVersion", "setPluginVersion", "build", "Lcom/netflix/spinnaker/kork/plugins/internal/PluginJar;", "createManifest", "Ljava/util/jar/Manifest;", "extension", "extensionClassName", "extensionClassNames", "extensionsAsByteArray", "", "manifestAttribute", "name", "value", "", "kork-plugins-tck"})
    public static final class Builder {
        public String pluginClass;
        public String pluginVersion;
        private final Map<String, String> manifestAttributes;
        private final List<String> extensions;
        private ClassDataProvider classDataProvider;
        @NotNull
        private final Path path;
        @NotNull
        private final String pluginId;

        @NotNull
        public final String getPluginClass() {
            String string = this.pluginClass;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pluginClass");
            }
            return string;
        }

        public final void setPluginClass(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.pluginClass = string;
        }

        @NotNull
        public final String getPluginVersion() {
            String string = this.pluginVersion;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pluginVersion");
            }
            return string;
        }

        public final void setPluginVersion(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.pluginVersion = string;
        }

        @NotNull
        public final Builder pluginClass(@NotNull String pluginClass) {
            Intrinsics.checkNotNullParameter((Object)pluginClass, (String)"pluginClass");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.pluginClass = pluginClass;
            return builder;
        }

        @NotNull
        public final Builder pluginVersion(@NotNull String pluginVersion) {
            Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.pluginVersion = pluginVersion;
            return builder;
        }

        @NotNull
        public final Builder extension(@NotNull String extensionClassName) {
            Intrinsics.checkNotNullParameter((Object)extensionClassName, (String)"extensionClassName");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.extensions.add(extensionClassName);
            return builder;
        }

        @NotNull
        public final Builder extensions(@NotNull List<String> extensionClassNames) {
            Intrinsics.checkNotNullParameter(extensionClassNames, (String)"extensionClassNames");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.extensions.addAll((Collection<String>)extensionClassNames);
            return builder;
        }

        @NotNull
        public final Builder classDataProvider(@NotNull ClassDataProvider classDataProvider) {
            Intrinsics.checkNotNullParameter((Object)classDataProvider, (String)"classDataProvider");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.classDataProvider = classDataProvider;
            return builder;
        }

        @NotNull
        public final Builder manifestAttributes(@NotNull Map<String, String> manifestAttributes) {
            Intrinsics.checkNotNullParameter(manifestAttributes, (String)"manifestAttributes");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.manifestAttributes.putAll(manifestAttributes);
            return builder;
        }

        @NotNull
        public final Builder manifestAttribute(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.manifestAttributes.put(name, value);
            return builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final PluginJar build() {
            Manifest manifest = this.createManifest();
            Closeable closeable = new FileOutputStream(this.path.toFile());
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable;
                boolean bl3 = false;
                JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)outputStream, manifest);
                Collection collection = this.extensions;
                boolean bl4 = false;
                if (!collection.isEmpty()) {
                    JarEntry jarEntry = new JarEntry("META-INF/extensions.idx");
                    jarOutputStream.putNextEntry(jarEntry);
                    jarOutputStream.write(this.extensionsAsByteArray());
                    jarOutputStream.closeEntry();
                    for (String extension : this.extensions) {
                        String extensionPath = StringsKt.replace$default((String)extension, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
                        JarEntry classEntry = new JarEntry(extensionPath);
                        jarOutputStream.putNextEntry(classEntry);
                        jarOutputStream.write(this.classDataProvider.getClassData(extension));
                        jarOutputStream.closeEntry();
                    }
                }
                jarOutputStream.close();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return new PluginJar(this, null);
        }

        private final Manifest createManifest() {
            boolean bl = false;
            Map map = new LinkedHashMap();
            map.put("Plugin-Id", this.pluginId);
            String string = this.pluginVersion;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pluginVersion");
            }
            map.put("Plugin-Version", string);
            String string2 = this.pluginClass;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pluginClass");
            }
            map.put("Plugin-Class", string2);
            map.putAll(this.manifestAttributes);
            return Companion.createManifest(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] extensionsAsByteArray() {
            Closeable closeable = new ByteArrayOutputStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
                boolean bl3 = false;
                PrintWriter writer = new PrintWriter(outputStream);
                for (String extension : this.extensions) {
                    writer.println(extension);
                }
                writer.flush();
                byte[] byArray = outputStream.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
                byte[] byArray2 = byArray;
                return byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final String getPluginId() {
            return this.pluginId;
        }

        public Builder(@NotNull Path path, @NotNull String pluginId) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
            this.path = path;
            this.pluginId = pluginId;
            boolean bl = false;
            this.manifestAttributes = new LinkedHashMap();
            bl = false;
            this.extensions = new ArrayList();
            this.classDataProvider = new DefaultClassDataProvider();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lcom/netflix/spinnaker/kork/plugins/internal/PluginJar$Companion;", "", "()V", "createManifest", "Ljava/util/jar/Manifest;", "map", "", "", "kork-plugins-tck"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Manifest createManifest(@NotNull Map<String, String> map) {
            Attributes attributes;
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Manifest manifest = new Manifest();
            Attributes attributes2 = attributes = manifest.getMainAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)attributes2, (String)"attributes");
            ((Map)attributes2).put(Attributes.Name.MANIFEST_VERSION, "1.0.0");
            Object object = map;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                String value = entry2.getValue();
                ((Map)attributes).put(new Attributes.Name((String)key), value);
            }
            return manifest;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

