/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.plugins.testplugin;

import com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor;
import com.netflix.spinnaker.kork.plugins.finders.SpinnakerPropertiesPluginDescriptorFinder;
import com.netflix.spinnaker.kork.plugins.testplugin.DefaultPluginClassSourceFile;
import com.netflix.spinnaker.kork.plugins.testplugin.SourceFile;
import com.netflix.spinnaker.kork.plugins.testplugin.TestPluginGenerator;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pf4j.PluginDescriptor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u0006J\u0012\u0010$\u001a\u00020%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b(J\u000e\u0010\u000f\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0006J\u0006\u0010+\u001a\u00020\u0006J\u0016\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000b\u00a8\u00061"}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin;", "", "()V", "generated", "", "value", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "packageName", "getPackageName", "setPackageName", "pluginClass", "Lcom/netflix/spinnaker/kork/plugins/testplugin/SourceFile;", "getPluginClass$kork_plugins_tck", "()Lcom/netflix/spinnaker/kork/plugins/testplugin/SourceFile;", "setPluginClass$kork_plugins_tck", "(Lcom/netflix/spinnaker/kork/plugins/testplugin/SourceFile;)V", "pluginId", "getPluginId", "setPluginId", "sources", "", "getSources$kork_plugins_tck", "()Ljava/util/List;", "setSources$kork_plugins_tck", "(Ljava/util/List;)V", "version", "getVersion", "setVersion", "canonicalClass", "className", "canonicalPluginClass", "generate", "Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin$GenerateResult;", "rootPath", "Ljava/nio/file/Path;", "pluginClass$kork_plugins_tck", "", "contents", "properties", "sourceFile", "simpleName", "sourceFiles", "", "GenerateResult", "kork-plugins-tck"})
public final class GeneratedTestPlugin {
    @NotNull
    private String name = "Generated";
    @NotNull
    private String packageName = "com.netflix.spinnaker.kork.plugins.testplugin.generated";
    @NotNull
    private String version = "0.0.1";
    @NotNull
    private String pluginId;
    @NotNull
    private List<SourceFile> sources;
    @Nullable
    private SourceFile pluginClass;
    private boolean generated;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = StringsKt.capitalize((String)value);
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    public final void setPackageName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.packageName = string;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.version = string;
    }

    @NotNull
    public final String getPluginId() {
        return this.pluginId;
    }

    public final void setPluginId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pluginId = string;
    }

    @NotNull
    public final List<SourceFile> getSources$kork_plugins_tck() {
        return this.sources;
    }

    public final void setSources$kork_plugins_tck(@NotNull List<SourceFile> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.sources = list;
    }

    @Nullable
    public final SourceFile getPluginClass$kork_plugins_tck() {
        return this.pluginClass;
    }

    public final void setPluginClass$kork_plugins_tck(@Nullable SourceFile sourceFile) {
        this.pluginClass = sourceFile;
    }

    public final void pluginClass(@NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        this.pluginClass = new SourceFile(this.name, contents);
    }

    public final void sourceFile(@NotNull String simpleName, @NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        this.sources.add(new SourceFile(simpleName, contents));
    }

    @NotNull
    public final List<SourceFile> sourceFiles() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.pluginClass$kork_plugins_tck()), (Iterable)this.sources);
    }

    @NotNull
    public final SourceFile pluginClass$kork_plugins_tck() {
        SourceFile sourceFile = this.pluginClass;
        if (sourceFile == null) {
            sourceFile = new DefaultPluginClassSourceFile(this.name, this.packageName);
        }
        return sourceFile;
    }

    @NotNull
    public final String properties() {
        return StringsKt.trimIndent((String)("\n      plugin.id=" + this.pluginId + "\n      plugin.description=A generated TestPlugin named " + this.name + "\n      plugin.class=" + this.canonicalPluginClass() + "\n      plugin.version=" + this.version + "\n      plugin.provider=Spinnaker\n      plugin.dependencies=\n      plugin.requires=*\n      plugin.license=Apache 2.0\n      plugin.unsafe=false\n    "));
    }

    @NotNull
    public final String canonicalClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return this.packageName + '.' + className;
    }

    @NotNull
    public final String canonicalPluginClass() {
        return this.canonicalClass(this.pluginClass$kork_plugins_tck().getSimpleName());
    }

    @NotNull
    public final GenerateResult generate(@Nullable Path rootPath) {
        if (this.generated) {
            throw (Throwable)new IllegalStateException("A test plugin instance cannot be generated more than once");
        }
        Path path = rootPath;
        if (path == null) {
            path = Files.createTempDirectory("generatedplugin", new FileAttribute[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootPath ?: Files.create\u2026ectory(\"generatedplugin\")");
        TestPluginGenerator testPluginGenerator = new TestPluginGenerator(this, path);
        boolean bl = false;
        boolean bl2 = false;
        TestPluginGenerator it = testPluginGenerator;
        boolean bl3 = false;
        it.generate();
        this.generated = true;
        PluginDescriptor pluginDescriptor = new SpinnakerPropertiesPluginDescriptorFinder(null, 1, null).find(it.getPluginPath());
        if (pluginDescriptor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.netflix.spinnaker.kork.plugins.SpinnakerPluginDescriptor");
        }
        return new GenerateResult(it.getRootPath(), it.getPluginPath(), (SpinnakerPluginDescriptor)pluginDescriptor, this);
    }

    public static /* synthetic */ GenerateResult generate$default(GeneratedTestPlugin generatedTestPlugin, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        return generatedTestPlugin.generate(path);
    }

    public GeneratedTestPlugin() {
        StringBuilder stringBuilder = new StringBuilder().append("spinnaker.");
        String string = this.name;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        this.pluginId = stringBuilder.append(string3).append("-testplugin").toString();
        boolean bl2 = false;
        this.sources = new ArrayList();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin$GenerateResult;", "", "rootPath", "Ljava/nio/file/Path;", "pluginPath", "descriptor", "Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;", "plugin", "Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin;)V", "getDescriptor", "()Lcom/netflix/spinnaker/kork/plugins/SpinnakerPluginDescriptor;", "getPlugin", "()Lcom/netflix/spinnaker/kork/plugins/testplugin/GeneratedTestPlugin;", "getPluginPath", "()Ljava/nio/file/Path;", "getRootPath", "kork-plugins-tck"})
    public static final class GenerateResult {
        @NotNull
        private final Path rootPath;
        @NotNull
        private final Path pluginPath;
        @NotNull
        private final SpinnakerPluginDescriptor descriptor;
        @NotNull
        private final GeneratedTestPlugin plugin;

        @NotNull
        public final Path getRootPath() {
            return this.rootPath;
        }

        @NotNull
        public final Path getPluginPath() {
            return this.pluginPath;
        }

        @NotNull
        public final SpinnakerPluginDescriptor getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public final GeneratedTestPlugin getPlugin() {
            return this.plugin;
        }

        public GenerateResult(@NotNull Path rootPath, @NotNull Path pluginPath, @NotNull SpinnakerPluginDescriptor descriptor, @NotNull GeneratedTestPlugin plugin) {
            Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
            Intrinsics.checkNotNullParameter((Object)pluginPath, (String)"pluginPath");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            this.rootPath = rootPath;
            this.pluginPath = pluginPath;
            this.descriptor = descriptor;
            this.plugin = plugin;
        }
    }
}

